/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.expr;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import net.morilib.db.engine.SqlEngine;
import net.morilib.db.relations.RelationAggregate;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.schema.SqlSchema;

public class RelationFunctionApply extends RelationExpression {

	//
	private RelationFunction op;
	private List<RelationExpression> exs;

	public RelationFunctionApply(RelationFunction o,
			List<RelationExpression> ex) {
		op  = o;
		exs = new ArrayList<RelationExpression>(ex);
	}

	@Override
	public Object eval(SqlEngine v, SqlSchema f,
			RelationTuple tuple, RelationAggregate m,
			List<String> group,
			List<Object> h) throws IOException, SQLException {
		Object[] a = new Object[exs.size()];
		List<Object> l = new ArrayList<Object>();

		for(int i = 0; i < exs.size(); i++) {
			if(group != null) {
				for(String s : group)  l.add(tuple.get(s));
			}
			a[i] = exs.get(i).eval(v, f, tuple, m, group, h);
		}
		return op.operate(m, l, a);
	}

	@Override
	public boolean isAggregate() {
		boolean b = op.isAggregate();

		if(b) {
			return true;
		} else {
			for(RelationExpression f : exs) {
				if(f.isAggregate())  return true;
			}
			return false;
		}
	}

	@Override
	public Object init(RelationAggregate m) throws SQLException {
		for(RelationExpression f : exs)  f.init(m);
		return op.init(m);
	}

}
