package net.morilib.db.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;

import net.morilib.db.expr.RelationFunction;
import net.morilib.db.functions.FunctionType;
import net.morilib.db.info.ColumnsInfo;
import net.morilib.db.info.PrimaryKeysInfo;
import net.morilib.db.info.TableTypesInfo;
import net.morilib.db.info.TablesInfo;
import net.morilib.db.info.TypeInfoInfo;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.sql.RePlus;

public class RelationsDatabaseMetadata implements DatabaseMetaData {

	RelationsConnection conn;

	RelationsDatabaseMetadata(RelationsConnection c) {
		conn = c;
	}

	@Override
	public <T> T unwrap(Class<T> iface) throws SQLException {
		throw new SQLFeatureNotSupportedException();
	}

	@Override
	public boolean isWrapperFor(Class<?> iface) throws SQLException {
		return false;
	}

	@Override
	public boolean allProceduresAreCallable() throws SQLException {
		return false;
	}

	@Override
	public boolean allTablesAreSelectable() throws SQLException {
		return true;
	}

	@Override
	public String getURL() throws SQLException {
		return null;
	}

	@Override
	public String getUserName() throws SQLException {
		return "user";
	}

	@Override
	public boolean isReadOnly() throws SQLException {
		return conn.isReadOnly();
	}

	@Override
	public boolean nullsAreSortedHigh() throws SQLException {
		return true;
	}

	@Override
	public boolean nullsAreSortedLow() throws SQLException {
		return false;
	}

	@Override
	public boolean nullsAreSortedAtStart() throws SQLException {
		return false;
	}

	@Override
	public boolean nullsAreSortedAtEnd() throws SQLException {
		return false;
	}

	@Override
	public String getDatabaseProductName() throws SQLException {
		return "morilib relations";
	}

	@Override
	public String getDatabaseProductVersion() throws SQLException {
		return RePlus.VERSION;
	}

	@Override
	public String getDriverName() throws SQLException {
		return "morilib relations JDBC driver";
	}

	@Override
	public String getDriverVersion() throws SQLException {
		return "0.0";
	}

	@Override
	public int getDriverMajorVersion() {
		return 0;
	}

	@Override
	public int getDriverMinorVersion() {
		return 0;
	}

	@Override
	public boolean usesLocalFiles() throws SQLException {
		return conn.schema.usesLocalFiles().isTrue();
	}

	@Override
	public boolean usesLocalFilePerTable() throws SQLException {
		return conn.schema.usesLocalFilePerTable().isTrue();
	}

	@Override
	public boolean supportsMixedCaseIdentifiers() throws SQLException {
		return false;
	}

	@Override
	public boolean storesUpperCaseIdentifiers() throws SQLException {
		return true;
	}

	@Override
	public boolean storesLowerCaseIdentifiers() throws SQLException {
		return false;
	}

	@Override
	public boolean storesMixedCaseIdentifiers() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
		return false;
	}

	@Override
	public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
		return true;
	}

	@Override
	public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
		return false;
	}

	@Override
	public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
		return false;
	}

	@Override
	public String getIdentifierQuoteString() throws SQLException {
		return "\"";
	}

	@Override
	public String getSQLKeywords() throws SQLException {
		return "";
	}

	@Override
	public String getNumericFunctions() throws SQLException {
		return RelationFunction.getListString(FunctionType.NUMERIC);
	}

	@Override
	public String getStringFunctions() throws SQLException {
		return RelationFunction.getListString(FunctionType.STRING);
	}

	@Override
	public String getSystemFunctions() throws SQLException {
		return RelationFunction.getListString(FunctionType.SYSTEM);
	}

	@Override
	public String getTimeDateFunctions() throws SQLException {
		return RelationFunction.getListString(FunctionType.TIME_DATE);
	}

	@Override
	public String getSearchStringEscape() throws SQLException {
		return "\\";
	}

	@Override
	public String getExtraNameCharacters() throws SQLException {
		return "$";
	}

	@Override
	public boolean supportsAlterTableWithAddColumn() throws SQLException {
		return !conn.isReadOnly();
	}

	@Override
	public boolean supportsAlterTableWithDropColumn() throws SQLException {
		return !conn.isReadOnly();
	}

	@Override
	public boolean supportsColumnAliasing() throws SQLException {
		return false;
	}

	@Override
	public boolean nullPlusNonNullIsNull() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsConvert() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsConvert(int fromType,
			int toType) throws SQLException {
		return false;
	}

	@Override
	public boolean supportsTableCorrelationNames() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsDifferentTableCorrelationNames() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsExpressionsInOrderBy() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsOrderByUnrelated() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsGroupBy() throws SQLException {
		return true;
	}

	@Override
	public boolean supportsGroupByUnrelated() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsGroupByBeyondSelect() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsLikeEscapeClause() throws SQLException {
		return true;
	}

	@Override
	public boolean supportsMultipleResultSets() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsMultipleTransactions() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsNonNullableColumns() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsMinimumSQLGrammar() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsCoreSQLGrammar() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsExtendedSQLGrammar() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsANSI92EntryLevelSQL() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsANSI92IntermediateSQL() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsANSI92FullSQL() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsIntegrityEnhancementFacility() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsOuterJoins() throws SQLException {
		return true;
	}

	@Override
	public boolean supportsFullOuterJoins() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsLimitedOuterJoins() throws SQLException {
		return false;
	}

	@Override
	public String getSchemaTerm() throws SQLException {
		return "schema";
	}

	@Override
	public String getProcedureTerm() throws SQLException {
		return "procedure";
	}

	@Override
	public String getCatalogTerm() throws SQLException {
		return "catalog";
	}

	@Override
	public boolean isCatalogAtStart() throws SQLException {
		return false;
	}

	@Override
	public String getCatalogSeparator() throws SQLException {
		return "";
	}

	@Override
	public boolean supportsSchemasInDataManipulation() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsSchemasInProcedureCalls() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsSchemasInTableDefinitions() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsSchemasInIndexDefinitions() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsCatalogsInDataManipulation() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsCatalogsInProcedureCalls() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsCatalogsInTableDefinitions() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsPositionedDelete() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsPositionedUpdate() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsSelectForUpdate() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsStoredProcedures() throws SQLException {
		// TODO
		return false;
	}

	@Override
	public boolean supportsSubqueriesInComparisons() throws SQLException {
		return true;
	}

	@Override
	public boolean supportsSubqueriesInExists() throws SQLException {
		return true;
	}

	@Override
	public boolean supportsSubqueriesInIns() throws SQLException {
		return true;
	}

	@Override
	public boolean supportsSubqueriesInQuantifieds() throws SQLException {
		return true;
	}

	@Override
	public boolean supportsCorrelatedSubqueries() throws SQLException {
		return true;
	}

	@Override
	public boolean supportsUnion() throws SQLException {
		return true;
	}

	@Override
	public boolean supportsUnionAll() throws SQLException {
		return true;
	}

	@Override
	public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
		return false;
	}

	@Override
	public int getMaxBinaryLiteralLength() throws SQLException {
		return 0;
	}

	@Override
	public int getMaxCharLiteralLength() throws SQLException {
		return 0;
	}

	@Override
	public int getMaxColumnNameLength() throws SQLException {
		return 0;
	}

	@Override
	public int getMaxColumnsInGroupBy() throws SQLException {
		return 0;
	}

	@Override
	public int getMaxColumnsInIndex() throws SQLException {
		return 0;
	}

	@Override
	public int getMaxColumnsInOrderBy() throws SQLException {
		return 0;
	}

	@Override
	public int getMaxColumnsInSelect() throws SQLException {
		return 0;
	}

	@Override
	public int getMaxColumnsInTable() throws SQLException {
		return 0;
	}

	@Override
	public int getMaxConnections() throws SQLException {
		return 0;
	}

	@Override
	public int getMaxCursorNameLength() throws SQLException {
		return 0;
	}

	@Override
	public int getMaxIndexLength() throws SQLException {
		return 0;
	}

	@Override
	public int getMaxSchemaNameLength() throws SQLException {
		return 0;
	}

	@Override
	public int getMaxProcedureNameLength() throws SQLException {
		return 0;
	}

	@Override
	public int getMaxCatalogNameLength() throws SQLException {
		return 0;
	}

	@Override
	public int getMaxRowSize() throws SQLException {
		return 0;
	}

	@Override
	public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
		return false;
	}

	@Override
	public int getMaxStatementLength() throws SQLException {
		return 0;
	}

	@Override
	public int getMaxStatements() throws SQLException {
		return 0;
	}

	@Override
	public int getMaxTableNameLength() throws SQLException {
		return 0;
	}

	@Override
	public int getMaxTablesInSelect() throws SQLException {
		return 0;
	}

	@Override
	public int getMaxUserNameLength() throws SQLException {
		return 0;
	}

	@Override
	public int getDefaultTransactionIsolation() throws SQLException {
		return Connection.TRANSACTION_NONE;
	}

	@Override
	public boolean supportsTransactions() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsTransactionIsolationLevel(
			int level) throws SQLException {
		return false;
	}

	@Override
	public boolean supportsDataDefinitionAndDataManipulationTransactions(
			) throws SQLException {
		return false;
	}

	@Override
	public boolean supportsDataManipulationTransactionsOnly(
			) throws SQLException {
		return false;
	}

	@Override
	public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
		return false;
	}

	@Override
	public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
		return false;
	}

	@Override
	public ResultSet getProcedures(String catalog,
			String schemaPattern,
			String procedureNamePattern) throws SQLException {
		// TODO
		return new NullResultSet(
				"PROCEDURE_CAT",
				"PROCEDURE_SCHEM",
				"PROCEDURE_NAME",
				"",
				"",
				"",
				"REMARKS",
				"PROCEDURE_TYPE",
				"SPECIFIC_NAME");
	}

	@Override
	public ResultSet getProcedureColumns(String catalog,
			String schemaPattern, String procedureNamePattern,
			String columnNamePattern) throws SQLException {
		// TODO
		return new NullResultSet(
				"PROCEDURE_CAT",
				"PROCEDURE_SCHEM",
				"PROCEDURE_NAME",
				"COLUMN_NAME",
				"COLUMN_TYPE",
				"DATA_TYPE",
				"TYPE_NAME",
				"PRECISION",
				"LENGTH",
				"SCALE",
				"RADIX",
				"NULLABLE",
				"REMARKS",
				"COLUMN_DEF",
				"SQL_DATA_TYPE",
				"SQL_DATETIME_SUB",
				"CHAR_OCTET_LENGTH",
				"ORDINAL_POSITION",
				"IS_NULLABLE",
				"SPECIFIC_NAME");
	}

	@Override
	public ResultSet getTables(String catalog, String schemaPattern,
			String tableNamePattern,
			String[] types) throws SQLException {
		try {
			return TablesInfo.get(conn.schema, tableNamePattern,
					types);
		} catch (IOException e) {
			throw ErrorBundle.getDefault(10037);
		}
	}

	@Override
	public ResultSet getSchemas() throws SQLException {
		return new NullResultSet(
				"TABLE_SCHEM",
				"TABLE_CATALOG");
	}

	@Override
	public ResultSet getCatalogs() throws SQLException {
		return new NullResultSet("TABLE_CAT");
	}

	@Override
	public ResultSet getTableTypes() throws SQLException {
		try {
			return TableTypesInfo.get();
		} catch (IOException e) {
			throw ErrorBundle.getDefault(10037);
		}
	}

	@Override
	public ResultSet getColumns(String catalog, String schemaPattern,
			String tableNamePattern,
			String columnNamePattern) throws SQLException {
		try {
			return ColumnsInfo.get(conn.schema, tableNamePattern,
					columnNamePattern);
		} catch (IOException e) {
			throw ErrorBundle.getDefault(10037);
		}
	}

	@Override
	public ResultSet getColumnPrivileges(String catalog, String schema,
			String table,
			String columnNamePattern) throws SQLException {
		return new NullResultSet(
				"TABLE_CAT",
				"TABLE_SCHEM",
				"TABLE_NAME",
				"COLUMN_NAME",
				"GRANTOR",
				"GRANTEE",
				"PRIVILEGE",
				"IS_GRANTABLE");
	}

	@Override
	public ResultSet getTablePrivileges(String catalog,
			String schemaPattern,
			String tableNamePattern) throws SQLException {
		return new NullResultSet(
				"TABLE_CAT",
				"TABLE_SCHEM",
				"TABLE_NAME",
				"GRANTOR",
				"GRANTEE",
				"PRIVILEGE",
				"IS_GRANTABLE");
	}

	@Override
	public ResultSet getBestRowIdentifier(String catalog,
			String schema, String table, int scope,
			boolean nullable) throws SQLException {
		return new NullResultSet(
				"SCOPE",
				"COLUMN_NAME",
				"DATA_TYPE",
				"TYPE_NAME",
				"COLUMN_SIZE",
				"BUFFER_LENGTH",
				"DECIMAL_DIGITS",
				"PSEUDO_COLUMN");
	}

	@Override
	public ResultSet getVersionColumns(String catalog, String schema,
			String table) throws SQLException {
		return new NullResultSet(
				"SCOPE",
				"COLUMN_NAME",
				"DATA_TYPE",
				"TYPE_NAME",
				"COLUMN_SIZE",
				"BUFFER_LENGTH",
				"DECIMAL_DIGITS",
				"PSEUDO_COLUMN");
	}

	@Override
	public ResultSet getPrimaryKeys(String catalog, String schema,
			String table) throws SQLException {
		try {
			return PrimaryKeysInfo.get(conn.schema, table);
		} catch (IOException e) {
			throw ErrorBundle.getDefault(10037);
		}
	}

	@Override
	public ResultSet getImportedKeys(String catalog, String schema,
			String table) throws SQLException {
		return new NullResultSet(
				"PKTABLE_CAT",
				"PKTABLE_SCHEM",
				"PKTABLE_NAME",
				"PKCOLUMN_NAME",
				"FKTABLE_CAT",
				"FKTABLE_SCHEM",
				"FKTABLE_NAME",
				"FKCOLUMN_NAME",
				"KEY_SEQ",
				"UPDATE_RULE",
				"DELETE_RULE",
				"FK_NAME",
				"PK_NAME",
				"DEFERRABILITY");
	}

	@Override
	public ResultSet getExportedKeys(String catalog, String schema,
			String table) throws SQLException {
		return new NullResultSet(
				"PKTABLE_CAT",
				"PKTABLE_SCHEM",
				"PKTABLE_NAME",
				"PKCOLUMN_NAME",
				"FKTABLE_CAT",
				"FKTABLE_SCHEM",
				"FKTABLE_NAME",
				"FKCOLUMN_NAME",
				"KEY_SEQ",
				"UPDATE_RULE",
				"DELETE_RULE",
				"FK_NAME",
				"PK_NAME",
				"DEFERRABILITY");
	}

	@Override
	public ResultSet getCrossReference(String parentCatalog,
			String parentSchema, String parentTable,
			String foreignCatalog, String foreignSchema,
			String foreignTable) throws SQLException {
		return new NullResultSet(
				"PKTABLE_CAT",
				"PKTABLE_SCHEM",
				"PKTABLE_NAME",
				"PKCOLUMN_NAME",
				"FKTABLE_CAT",
				"FKTABLE_SCHEM",
				"FKTABLE_NAME",
				"FKCOLUMN_NAME",
				"KEY_SEQ",
				"UPDATE_RULE",
				"DELETE_RULE",
				"FK_NAME",
				"PK_NAME",
				"DEFERRABILITY");
	}

	@Override
	public ResultSet getTypeInfo() throws SQLException {
		try {
			return TypeInfoInfo.get();
		} catch (IOException e) {
			throw ErrorBundle.getDefault(10037);
		}
	}

	@Override
	public ResultSet getIndexInfo(String catalog, String schema,
			String table, boolean unique,
			boolean approximate) throws SQLException {
		return new NullResultSet(
				"TABLE_CAT",
				"TABLE_SCHEM",
				"TABLE_NAME",
				"NON_UNIQUE",
				"INDEX_QUALIFIER",
				"INDEX_NAME",
				"TYPE",
				"ORDINAL_POSITION",
				"COLUMN_NAME",
				"ASC_OR_DESC",
				"CARDINALITY",
				"PAGES",
				"FILTER_CONDITION");
	}

	@Override
	public boolean supportsResultSetType(int type) throws SQLException {
		return (type == java.sql.Types.VARCHAR ||
				type == java.sql.Types.NUMERIC ||
				type == java.sql.Types.TIMESTAMP);
	}

	@Override
	public boolean supportsResultSetConcurrency(int type,
			int concurrency) throws SQLException {
		return false;
	}

	@Override
	public boolean ownUpdatesAreVisible(int type) throws SQLException {
		return false;
	}

	@Override
	public boolean ownDeletesAreVisible(int type) throws SQLException {
		return false;
	}

	@Override
	public boolean ownInsertsAreVisible(int type) throws SQLException {
		return false;
	}

	@Override
	public boolean othersUpdatesAreVisible(int type) throws SQLException {
		return false;
	}

	@Override
	public boolean othersDeletesAreVisible(int type) throws SQLException {
		return false;
	}

	@Override
	public boolean othersInsertsAreVisible(int type) throws SQLException {
		return false;
	}

	@Override
	public boolean updatesAreDetected(int type) throws SQLException {
		return false;
	}

	@Override
	public boolean deletesAreDetected(int type) throws SQLException {
		return false;
	}

	@Override
	public boolean insertsAreDetected(int type) throws SQLException {
		return false;
	}

	@Override
	public boolean supportsBatchUpdates() throws SQLException {
		return false;
	}

	@Override
	public ResultSet getUDTs(String catalog, String schemaPattern,
			String typeNamePattern, int[] types) throws SQLException {
		return new NullResultSet(
				"TYPE_CAT",
				"TYPE_SCHEM",
				"TYPE_NAME",
				"CLASS_NAME",
				"DATA_TYPE",
				"REMARKS",
				"BASE_TYPE");
	}

	@Override
	public Connection getConnection() throws SQLException {
		return conn;
	}

	@Override
	public boolean supportsSavepoints() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsNamedParameters() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsMultipleOpenResults() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsGetGeneratedKeys() throws SQLException {
		return false;
	}

	@Override
	public ResultSet getSuperTypes(String catalog,
			String schemaPattern,
			String typeNamePattern) throws SQLException {
		return new NullResultSet(
				"TYPE_CAT",
				"TYPE_SCHEM",
				"TYPE_NAME",
				"SUPERTYPE_CAT",
				"SUPERTYPE_SCHEM",
				"SUPERTYPE_NAME");
	}

	@Override
	public ResultSet getSuperTables(String catalog,
			String schemaPattern,
			String tableNamePattern) throws SQLException {
		return new NullResultSet(
				"TYPE_CAT",
				"TYPE_SCHEM",
				"TYPE_NAME",
				"SUPERTABLE_NAME");
	}

	@Override
	public ResultSet getAttributes(String catalog,
			String schemaPattern,
			String typeNamePattern, String attributeNamePattern)
			throws SQLException {
		return new NullResultSet(
				"TYPE_CAT",
				"TYPE_SCHEM",
				"TYPE_NAME",
				"ATTR_NAME",
				"DATA_TYPE",
				"ATTR_TYPE_NAME",
				"ATTR_SIZE",
				"DECIMAL_DIGITS",
				"NUM_PREC_RADIX",
				"NULLABLE",
				"REMARKS",
				"ATTR_DEF",
				"SQL_DATA_TYPE",
				"SQL_DATETIME_SUB",
				"CHAR_OCTET_LENGTH",
				"ORDINAL_POSITION",
				"IS_NULLABLE",
				"SCOPE_CATALOG",
				"SCOPE_SCHEMA",
				"SCOPE_TABLE",
				"SOURCE_DATA_TYPE");
	}

	@Override
	public boolean supportsResultSetHoldability(
			int holdability) throws SQLException {
		return false;
	}

	@Override
	public int getResultSetHoldability() throws SQLException {
		return ResultSet.HOLD_CURSORS_OVER_COMMIT;
	}

	@Override
	public int getDatabaseMajorVersion() throws SQLException {
		return RePlus.MAJOR_VERSION;
	}

	@Override
	public int getDatabaseMinorVersion() throws SQLException {
		return RePlus.MINOR_VERSION;
	}

	@Override
	public int getJDBCMajorVersion() throws SQLException {
		return 4;
	}

	@Override
	public int getJDBCMinorVersion() throws SQLException {
		return 0;
	}

	@Override
	public int getSQLStateType() throws SQLException {
		return sqlStateSQL;
	}

	@Override
	public boolean locatorsUpdateCopy() throws SQLException {
		return false;
	}

	@Override
	public boolean supportsStatementPooling() throws SQLException {
		return false;
	}

	@Override
	public RowIdLifetime getRowIdLifetime() throws SQLException {
		return RowIdLifetime.ROWID_UNSUPPORTED;
	}

	@Override
	public ResultSet getSchemas(String catalog,
			String schemaPattern) throws SQLException {
		return new NullResultSet(
				"TABLE_SCHEM",
				"TABLE_CATALOG");
	}

	@Override
	public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
		return false;
	}

	@Override
	public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
		return false;
	}

	@Override
	public ResultSet getClientInfoProperties() throws SQLException {
		return new NullResultSet(
				"NAME",
				"MAX_LEN",
				"DEFAULT_VALUE",
				"DESCRIPTION");
	}

	@Override
	public ResultSet getFunctions(String catalog, String schemaPattern,
			String functionNamePattern) throws SQLException {
		// TODO
		return new NullResultSet(
				"FUNCTION_CAT",
				"FUNCTION_SCHEM",
				"FUNCTION_NAME",
				"REMARKS",
				"FUNCTION_TYPE",
				"SPECIFIC_NAME");
	}

	@Override
	public ResultSet getFunctionColumns(String catalog,
			String schemaPattern, String functionNamePattern,
			String columnNamePattern) throws SQLException {
		// TODO
		return new NullResultSet(
				"FUNCTION_CAT",
				"FUNCTION_SCHEM",
				"FUNCTION_NAME",
				"COLUMN_NAME",
				"COLUMN_TYPE",
				"DATA_TYPE",
				"TYPE_NAME",
				"PRECISION",
				"LENGTH",
				"SCALE",
				"RADIX",
				"NULLABLE",
				"REMARKS",
				"CHAR_OCTET_LENGTH",
				"ORDINAL_POSITION",
				"IS_NULLABLE",
				"SPECIFIC_NAME");
	}

}
