package net.morilib.db.info;

import java.io.IOException;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import net.morilib.db.jdbc.BeanListResultSet;

public class TypeInfoInfo {

	static final String[] INFO = new String[] {
		"typeName",
		"dataType",
		"precision",
		"literalPrefix",
		"literalSuffix",
		"createParams",
		"nullable",
		"caseSensitive",
		"searchable",
		"unsignedAttribute",
		"fixedPrecScale",
		"autoIncrement",
		"localTypeName",
		"minimumScale",
		"maximumScale",
		"sqlDataType",
		"sqlDatetypeSub",
		"numPrecRadix",
	};

	public static BeanListResultSet get() throws IOException, SQLException {
		List<TypeInfoInfo> l = new ArrayList<TypeInfoInfo>();
		TypeInfoInfo f;

		f = new TypeInfoInfo();
		f.typeName = "VARCHAR";
		f.dataType = java.sql.Types.VARCHAR;
		f.precision = Integer.MAX_VALUE;
		f.nullable = DatabaseMetaData.typeNullable;
		f.caseSensitive = 0;
		f.searchable = DatabaseMetaData.typeSearchable;
		f.unsignedAttribute = 1;
		f.fixedPrecScale = 0;
		f.autoIncrement = 0;
		f.minimumScale = 0;
		f.maximumScale = 0;
		f.numPrecRadix = 10;
		l.add(f);

		f = new TypeInfoInfo();
		f.typeName = "NUMERIC";
		f.dataType = java.sql.Types.NUMERIC;
		f.precision = Integer.MAX_VALUE;
		f.nullable = DatabaseMetaData.typeNullable;
		f.caseSensitive = 0;
		f.searchable = DatabaseMetaData.typeSearchable;
		f.unsignedAttribute = 0;
		f.fixedPrecScale = 1;
		f.autoIncrement = 0;
		f.minimumScale = 0;
		f.maximumScale = Short.MAX_VALUE;
		f.numPrecRadix = 10;
		l.add(f);

		f = new TypeInfoInfo();
		f.typeName = "DATE";
		f.dataType = java.sql.Types.TIMESTAMP;
		f.nullable = DatabaseMetaData.typeNullable;
		f.caseSensitive = 0;
		f.searchable = DatabaseMetaData.typeSearchable;
		f.unsignedAttribute = 1;
		f.fixedPrecScale = 0;
		f.autoIncrement = 0;
		f.minimumScale = 0;
		f.maximumScale = 0;
		f.numPrecRadix = 10;
		l.add(f);
		return new BeanListResultSet(TypeInfoInfo.class,
				Arrays.asList(INFO), l);
	}

	private String typeName;
	private int dataType;
	private Integer precision;
	private String literalPrefix;
	private String literalSuffix;
	private String createParams;
	private short nullable;
	private int caseSensitive;
	private short searchable;
	private int unsignedAttribute;
	private int fixedPrecScale;
	private int autoIncrement;
	private String localTypeName;
	private short minimumScale;
	private short maximumScale;
	private int sqlDataType;
	private int sqlDatetypeSub;
	private short numPrecRadix;

	public int getAutoIncrement() {
		return autoIncrement;
	}

	public void setAutoIncrement(int autoIncrement) {
		this.autoIncrement = autoIncrement;
	}

	public String getTypeName() {
		return typeName;
	}

	public void setTypeName(String typeName) {
		this.typeName = typeName;
	}

	public int getDataType() {
		return dataType;
	}

	public void setDataType(int dataType) {
		this.dataType = dataType;
	}

	public Integer getPrecision() {
		return precision;
	}

	public void setPrecision(Integer precision) {
		this.precision = precision;
	}

	public String getLiteralPrefix() {
		return literalPrefix;
	}

	public void setLiteralPrefix(String literalPrefix) {
		this.literalPrefix = literalPrefix;
	}

	public String getLiteralSuffix() {
		return literalSuffix;
	}

	public void setLiteralSuffix(String literalSuffix) {
		this.literalSuffix = literalSuffix;
	}

	public String getCreateParams() {
		return createParams;
	}

	public void setCreateParams(String createParams) {
		this.createParams = createParams;
	}

	public short getNullable() {
		return nullable;
	}

	public void setNullable(short nullable) {
		this.nullable = nullable;
	}

	public int getCaseSensitive() {
		return caseSensitive;
	}

	public void setCaseSensitive(int caseSensitive) {
		this.caseSensitive = caseSensitive;
	}

	public short getSearchable() {
		return searchable;
	}

	public void setSearchable(short searchable) {
		this.searchable = searchable;
	}

	public int getUnsignedAttribute() {
		return unsignedAttribute;
	}

	public void setUnsignedAttribute(int unsignedAttribute) {
		this.unsignedAttribute = unsignedAttribute;
	}

	public int getFixedPrecScale() {
		return fixedPrecScale;
	}

	public void setFixedPrecScale(int fixedPrecScale) {
		this.fixedPrecScale = fixedPrecScale;
	}

	public String getLocalTypeName() {
		return localTypeName;
	}

	public void setLocalTypeName(String localTypeName) {
		this.localTypeName = localTypeName;
	}

	public short getMinimumScale() {
		return minimumScale;
	}

	public void setMinimumScale(short minimumScale) {
		this.minimumScale = minimumScale;
	}

	public short getMaximumScale() {
		return maximumScale;
	}

	public void setMaximumScale(short maximumScale) {
		this.maximumScale = maximumScale;
	}

	public int getSqlDataType() {
		return sqlDataType;
	}

	public void setSqlDataType(int sqlDataType) {
		this.sqlDataType = sqlDataType;
	}

	public int getSqlDatetypeSub() {
		return sqlDatetypeSub;
	}

	public void setSqlDatetypeSub(int sqlDatetypeSub) {
		this.sqlDatetypeSub = sqlDatetypeSub;
	}

	public short getNumPrecRadix() {
		return numPrecRadix;
	}

	public void setNumPrecRadix(short numPrecRadix) {
		this.numPrecRadix = numPrecRadix;
	}

}
