/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.sqlcs.dml;

public class SqlTableColumn {

	/**
	 * 
	 */
	public static final SqlTableColumn WILDCARD =
			new SqlTableColumn(null, null);

	//
	private SqlExpression expr;
	private String as;

	/**
	 * 
	 * @param expression
	 * @param name
	 */
	public SqlTableColumn(SqlExpression expression, String name) {
		expr = expression;
		as   = name;
	}

	public SqlExpression getExpression() {
		return expr;
	}

	public String getAs() {
		if(as != null) {
			return as;
		} else if(expr instanceof SqlSymbol) {
			return ((SqlSymbol)expr).getValue();
		} else {
			return null;
		}
	}

	public String toString() {
		if(as != null) {
			return "(" + expr + " . " + as + ")";
		} else {
			return "(" + expr + " . #f)";
		}
	}

}
