/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.expr;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

import net.morilib.db.engine.SqlEngine;
import net.morilib.db.relations.Relation;
import net.morilib.db.relations.RelationAggregate;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.schema.SqlSchema;
import net.morilib.db.sqlcs.dml.SqlSelect;

public class RelationExists extends RelationExpression {

	//
	private SqlSelect select;

	public RelationExists(SqlSelect s) {
		select = s;
	}

	@Override
	public Object eval(SqlEngine v, SqlSchema f,
			RelationTuple tuple, RelationAggregate m,
			List<String> group,
			List<Object> h) throws IOException, SQLException {
		Relation r;

		r = v.visit(f, select, tuple, h);
		return value(r.iterator().hasNext());
	}

	@Override
	public boolean isAggregate() {
		return false;
	}

	@Override
	public Object init(SqlEngine v, SqlSchema f) throws SQLException {
		return RelationExpression.FALSE;
	}

}
