/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.delay;

import net.morilib.db.misc.Rational;

public class CorrelationDelay extends Buffered2Delay {

	@Override
	public Object force() {
		Rational v, x, y, mx, my, vx, vy;

		v = vx = vy = Rational.ZERO;
		mx = meanX();  my = meanY();
		for(int i = 0; i < size(); i++) {
			x  = valuesX.get(i).subtract(mx);
			y  = valuesY.get(i).subtract(my);
			v  = v.add(x.multiply(y));
			vx = vx.add(x.multiply(x));
			vy = vy.add(y.multiply(y));
		}
		return v.multiply(v).divide(vx).divide(vy);
	}

}
