/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.schema;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import net.morilib.db.fichier.FabriqueDeFichier;
import net.morilib.db.misc.NullBoolean;
import net.morilib.db.relations.NamedRelation;
import net.morilib.db.relations.Relation;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.relations.TableRenameRelation;
import net.morilib.db.sqlcs.ddl.SqlCreateTable;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/08/17
 */
public class WithSqlSchema implements SqlSchema {

	private SqlSchema wrap;
	private Map<String, Relation> rels;

	/**
	 * 
	 * @param w
	 * @param r
	 */
	public WithSqlSchema(SqlSchema w, Map<String, Relation> r) {
		wrap = w;
		rels = new HashMap<String, Relation>(r);
	}

	/**
	 * 
	 * @param w
	 * @param r
	 */
	public WithSqlSchema(SqlSchema w) {
		wrap = w;
		rels = new HashMap<String, Relation>();
	}

	/* (non-Javadoc)
	 * @see net.morilib.db.schema.SqlSchema#readRelation(java.lang.String, java.lang.String)
	 */
	@Override
	public NamedRelation readRelation(String name,
			String as) throws IOException, SQLException {
		return rels.containsKey(name) ?
				new TableRenameRelation(rels.get(name), as) :
					wrap.readRelation(name, as);
	}

	/* (non-Javadoc)
	 * @see net.morilib.db.schema.SqlSchema#writeRelation(java.lang.String, java.util.Collection)
	 */
	@Override
	public void writeRelation(String name,
			Collection<RelationTuple> z
			) throws IOException, SQLException {
		wrap.writeRelation(name, z);
	}

	/* (non-Javadoc)
	 * @see net.morilib.db.schema.SqlSchema#getCreateTable(java.lang.String)
	 */
	@Override
	public SqlCreateTable getCreateTable(
			String name) throws IOException, SQLException {
		return wrap.getCreateTable(name);
	}

	/* (non-Javadoc)
	 * @see net.morilib.db.schema.SqlSchema#isTable(java.lang.String)
	 */
	@Override
	public boolean isTable(
			String name) throws IOException, SQLException {
		return wrap.isTable(name);
	}

	/* (non-Javadoc)
	 * @see net.morilib.db.schema.SqlSchema#putCreateTable(java.lang.String, net.morilib.db.sqlcs.ddl.SqlCreateTable)
	 */
	@Override
	public void putCreateTable(String name,
			SqlCreateTable table) throws IOException, SQLException {
		wrap.putCreateTable(name, table);
	}

	/* (non-Javadoc)
	 * @see net.morilib.db.schema.SqlSchema#getTableNames()
	 */
	@Override
	public Collection<String> getTableNames(
			) throws IOException, SQLException {
		return wrap.getTableNames();
	}

	/* (non-Javadoc)
	 * @see net.morilib.db.schema.SqlSchema#truncateTable(java.lang.String)
	 */
	@Override
	public void truncateTable(
			String name) throws IOException, SQLException {
		wrap.truncateTable(name);
	}

	/* (non-Javadoc)
	 * @see net.morilib.db.schema.SqlSchema#removeCreateTable(java.lang.String)
	 */
	@Override
	public void removeCreateTable(
			String name) throws IOException, SQLException {
		wrap.removeCreateTable(name);
	}

	/* (non-Javadoc)
	 * @see net.morilib.db.schema.SqlSchema#alterCreateTable(java.lang.String, net.morilib.db.sqlcs.ddl.SqlCreateTable)
	 */
	@Override
	public void alterCreateTable(String name,
			SqlCreateTable table) throws IOException, SQLException {
		wrap.alterCreateTable(name, table);
	}

	/* (non-Javadoc)
	 * @see net.morilib.db.schema.SqlSchema#fork()
	 */
	@Override
	public SqlSchema fork() {
		return new WithSqlSchema(wrap, rels);
	}

	/* (non-Javadoc)
	 * @see net.morilib.db.schema.SqlSchema#isReadonly()
	 */
	@Override
	public NullBoolean isReadonly() {
		return wrap.isReadonly();
	}

	/* (non-Javadoc)
	 * @see net.morilib.db.schema.SqlSchema#usesLocalFiles()
	 */
	@Override
	public NullBoolean usesLocalFiles() {
		return wrap.usesLocalFiles();
	}

	/* (non-Javadoc)
	 * @see net.morilib.db.schema.SqlSchema#usesLocalFilePerTable()
	 */
	@Override
	public NullBoolean usesLocalFilePerTable() {
		return wrap.usesLocalFilePerTable();
	}

	/* (non-Javadoc)
	 * @see net.morilib.db.schema.SqlSchema#fabrique()
	 */
	@Override
	public FabriqueDeFichier fabrique() {
		return wrap.fabrique();
	}

	/* (non-Javadoc)
	 * @see net.morilib.db.schema.SqlSchema#bindSchema(java.lang.String, net.morilib.db.relations.Relation)
	 */
	@Override
	public void bindSchema(String name, Relation r) {
		rels.put(name, r);
	}

	/* (non-Javadoc)
	 * @see net.morilib.db.schema.SqlSchema#isAutoCommit()
	 */
	@Override
	public boolean isAutoCommit() {
		return wrap.isAutoCommit();
	}

	/* (non-Javadoc)
	 * @see net.morilib.db.schema.SqlSchema#isLocked(java.lang.String)
	 */
	@Override
	public boolean isLocked(String name) {
		return wrap.isLocked(name);
	}

	/* (non-Javadoc)
	 * @see net.morilib.db.schema.SqlSchema#lock(java.lang.String)
	 */
	@Override
	public void lock(String name) throws IOException {
		wrap.lock(name);
	}

	/* (non-Javadoc)
	 * @see net.morilib.db.schema.SqlSchema#unlock(java.lang.String)
	 */
	@Override
	public void unlock(String name) throws IOException {
		wrap.unlock(name);
	}

}
