/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.functions;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.List;

import net.morilib.db.misc.DefaultDelay;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.relations.RelationAggregate;
import net.morilib.db.relations.RelationExpression;
import net.morilib.db.relations.RelationFunction;

public class FnMax extends RelationFunction {

	@Override
	public boolean isAggregate() {
		return true;
	}

	@Override
	public Object operate(RelationAggregate m, List<Object> group,
			Object... args) throws SQLException {
		Object d;

		d = m.get(group).force();
		if(args.length != 1) {
			throw ErrorBundle.getDefault(10007, "MAX");
		} else if(args[0].equals("")) {
			// do nothing
		} else if(d.equals("")) {
			d = args[0];
		} else if(RelationExpression.cmp(args[0], d) > 0) {
			d = args[0];
		}
		m.put(group, new DefaultDelay(d));
		return d;
	}

	@Override
	public Object init(RelationAggregate m) throws SQLException {
		m.init(new DefaultDelay(""));
		return BigDecimal.ZERO;
	}

}
