/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.relations;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import net.morilib.db.engine.SqlEngine;
import net.morilib.db.misc.DefaultDelay;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.schema.SqlSchema;

public class OperatedRelation extends AbstractRelation {

	private Relation wrap;
	private SqlEngine visit;
	private SqlSchema fs;
	private List<RelationExpression> exprs;
	private List<RelationAggregate> map;
	private List<String> ases, group;
	private List<Object> holder;

	public OperatedRelation(Relation w, SqlEngine v,
			SqlSchema f, List<RelationExpression> e,
			List<String> a, List<String> g,
			List<Object> h) throws SQLException {
		RelationAggregate m;
		String s;

		wrap = w;
		visit = v;
		fs = f;
		exprs = new ArrayList<RelationExpression>(e);
		holder = new ArrayList<Object>(h);
//		ases  = new ArrayList<String>(a);
		ases  = new ArrayList<String>();
		for(int i = 0; i < a.size(); i++) {
			s = (s = a.get(i)) != null ? s : i + "";
			ases.add(s);
		}

		if(g != null) {
			group = new ArrayList<String>(g);
			map   = new ArrayList<RelationAggregate>();
			for(int i = 0; i < exprs.size(); i++) {
				map.add(m = new RelationAggregate());
				exprs.get(i).init(m);
			}
		}
	}

	public List<RelationAggregate> getMap() {
		return Collections.unmodifiableList(map);
	}

	public RelationCursor iterator() {
		final RelationCursor itr = wrap.iterator();

		return new RelationCursor() {

			public boolean hasNext() {
				return itr.hasNext();
			}

			public RelationTuple next(
					) throws IOException, SQLException {
				final Object[] a = new Object[exprs.size()];
				List<Object> l = new ArrayList<Object>();
				RelationTuple t = itr.next();

				for(int i = 0; i < exprs.size(); i++) {
					if(map != null) {
						a[i] = exprs.get(i).eval(visit, fs, t,
								map.get(i), group, holder);
						if(exprs.get(i) instanceof RelationRefer) {
							if(group != null) {
								for(String s : group)  l.add(t.get(s));
							}
							map.get(i).put(l, new DefaultDelay(a[i]));
						}
					} else {
						a[i] = exprs.get(i).eval(visit, fs, t, null,
								null, holder);
					}
				}
				return new RelationTuple() {

					@Override
					public Object get(
							String name) throws SQLException {
						int c;

						if((c = ases.indexOf(name)) < 0) {
							throw ErrorBundle.getDefault(10009, name);
						}
						return a[c];
					}

					@Override
					public RelationTuple copy() {
						return new DefaultRelationTuple(toMap());
					}

					@Override
					public Map<String, Object> toMap() {
						Map<String, Object> m;

						m = new LinkedHashMap<String, Object>();
						for(int i = 0; i < exprs.size(); i++) {
							m.put(ases.get(i), a[i]);
						}
						return m;
					}

				};
			}

		};
	}

	public List<String> getColumnNames() {
		return Collections.unmodifiableList(ases);
	}

}
