/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.schema;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.sqlcs.ddl.SqlColumnAttribute;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;
import net.morilib.db.sqlcs.ddl.SqlColumnType;
import net.morilib.db.sqlcs.ddl.SqlCreateTable;
import net.morilib.db.sqlcs.ddl.SqlTypeNumeric;
import net.morilib.db.sqlcs.ddl.SqlTypeVarchar;
import net.morilib.parser.csv.CSVConfig;
import net.morilib.parser.csv.CSVException;
import net.morilib.parser.csv.StringCSVPullParser;

public final class SqlSchemata {

	//
	private static final CSVConfig DEFT =
			new CSVConfig(",", '\"', false);
	private static final Pattern PT1 =
			Pattern.compile("[0-9]+|[0-9]*\\.[0-9]+");
	private static final Pattern PT2 = Pattern.compile("[^.]+");

	private static int seq = 1;

	private SqlSchemata() {}

	public static SqlCreateTable guessTable(
			String s) throws IOException, SQLException {
		StringCSVPullParser p = null;
		List<SqlColumnDefinition> l;
		BufferedReader r = null;
		File f = new File(s);
		SqlColumnType[] t;
		List<String> n;
		Set<String> z;
		String[] y;
		Matcher w;
		String v;

		try {
			r = new BufferedReader(new InputStreamReader(
					new FileInputStream(f)));
			p = new StringCSVPullParser(r, DEFT);

			if(!p.next()) {
				throw ErrorBundle.getDefault(10018);
			} else {
				n = new ArrayList<String>(Arrays.asList(p.get()));
				z = new HashSet<String>();
				for(int i = 0; i < n.size(); i++) {
					if(n.get(i).equals("") || z.contains(n.get(i))) {
						n.set(i, n.get(i).toUpperCase() + i);
					} else {
						n.set(i, n.get(i).toUpperCase());
					}
				}
			}

			t = new SqlColumnType[n.size()];
			for(int i = 0; i < n.size(); i++) {
				t[i] = new SqlTypeNumeric();
			}

			while(p.next()) {
				y = p.get();
				for(int i = 0; i < n.size(); i++) {
					if(i >= y.length) {
						// do nothing
					} else if(!PT1.matcher(y[i]).matches()) {
						t[i] = new SqlTypeVarchar();
					}
				}
			}

			l = new ArrayList<SqlColumnDefinition>();
			for(int i = 0; i < n.size(); i++) {
				l.add(new SqlColumnDefinition(n.get(i),
						t[i],
						EnumSet.noneOf(SqlColumnAttribute.class)));
			}
			w = PT2.matcher(s);
			v = w.lookingAt() ? w.group() : "table" + (seq++);
			return new SqlCreateTable(v.toUpperCase(), l);
		} catch(CSVException e) {
			throw ErrorBundle.getDefault(10042);
		} finally {
			if(p != null)  p.close();
		}
		
	}

}
