/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.sqlcs.ddl;

import java.sql.SQLException;
import java.text.SimpleDateFormat;

import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.misc.ParseDate;

public class SqlTypeDate extends SqlColumnType {

	private static final SimpleDateFormat F1 = new SimpleDateFormat(
			"yyyy/MM/dd HH:mm:ss");

	@Override
	public Object cast(String s) throws SQLException {
		try {
			return s.equals("") ? "" : ParseDate.toDate(s);
		} catch(IllegalArgumentException e) {
			throw ErrorBundle.getDefault(10034, s);
		}
	}

	@Override
	public String string(Object o) {
		return o.equals("") ? "" : F1.format((java.util.Date)o);
	}

	public String toString() {
		return "DATE";
	}

}
