/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.sqlcs.dml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SqlIn implements SqlExpression {

	//
	private SqlExpression exa;
	private List<SqlExpression> ins;

	public SqlIn(SqlExpression a, List<SqlExpression> in) {
		exa = a;
		ins = new ArrayList<SqlExpression>(in);
	}

	public SqlExpression getExpression() {
		return exa;
	}

	public List<SqlExpression> getValues() {
		return Collections.unmodifiableList(ins);
	}

	public String toString() {
		StringBuffer b = new StringBuffer("(in ");

		b.append(exa.toString());
		for(SqlExpression e : ins) {
			b.append(' ').append(e.toString());
		}
		return b.append(')').toString();
	}

}
