/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.sqlcs.dml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/08/07
 */
public class SqlUpdate {

	private String table;
	private List<String> names;
	private List<SqlExpression> expressions;
	private SqlExpression where;

	public SqlUpdate(String t, List<String> n, List<SqlExpression> e,
			SqlExpression w) {
		table = t;
		names = new ArrayList<String>(n);
		expressions = new ArrayList<SqlExpression>(e);
		where = w;
	}

	/**
	 * @return the table
	 */
	public String getTable() {
		return table;
	}

	/**
	 * @return the names
	 */
	public List<String> getNames() {
		return Collections.unmodifiableList(names);
	}

	/**
	 * @return the expressions
	 */
	public List<SqlExpression> getExpressions() {
		return Collections.unmodifiableList(expressions);
	}

	/**
	 * @return the where
	 */
	public SqlExpression getWhere() {
		return where;
	}

}
