/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.fichier;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class SandboxBaseFichier extends FabriqueDeFichier
implements Fichier {

	private Map<String, Fichier> directory;

	public SandboxBaseFichier() {
		directory = new HashMap<String, Fichier>();
	}

	@Override
	public Fichier newInstance(Fichier dir, String name) {
		Fichier f;

		if((f = directory.get(name)) == null) {
			f = new MemoryFichier(this, name);
			directory.put(name, f);
		}
		return f;
	}

	@Override
	public Fichier newInstance(String name) {
		return newInstance(name);
	}

	@Override
	public Fichier newInstance(File name) {
		return newInstance(name.getName());
	}

	@Override
	public Fichier createTempFile(String prefix,
			String suffix) throws IOException {
		return new FileFichier(File.createTempFile(prefix,
				suffix));
	}

	@Override
	public boolean isFile() {
		return false;
	}

	@Override
	public boolean createNewFile() throws IOException {
		return false;
	}

	@Override
	public Reader openReader() throws IOException {
		throw new IOException();
	}

	@Override
	public Writer openWriter() throws IOException {
		throw new IOException();
	}

	@Override
	public InputStream openInputStream() throws IOException {
		throw new IOException();
	}

	@Override
	public OutputStream openOutputStream() throws IOException {
		throw new IOException();
	}

	@Override
	public String getName() {
		return "";
	}

	@Override
	public boolean delete() throws IOException {
		return false;
	}

	@Override
	public Fichier[] listFichiers() {
		return directory.values().toArray(new Fichier[0]);
	}

	@Override
	public boolean renameTo(Fichier name) throws IOException {
		return false;
	}

	/* (non-Javadoc)
	 * @see net.morilib.db.fichier.Fichier#getParent()
	 */
	@Override
	public Fichier getParent() {
		return null;
	}

}
