/*
 * The MIT License (MIT)
 * 
 * Copyright (c) 2006 TERAI Atsuhiro
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package net.morilib.db.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.Icon;
import javax.swing.JTabbedPane;

/**
 *
 *
 */
public class JTabbedPaneWithCloseIcons extends JTabbedPane {

	public JTabbedPaneWithCloseIcons() {
		super();
		addMouseListener(new MouseAdapter() {

			@Override
			public void mouseClicked(MouseEvent e) {
				tabClicked(e);
			}

		});
	}

	public void addTab(String title, Component component) {
		this.addTab(title, component, null);
	}

	public void addTab(String title, Component component,
			Icon extraIcon) {
		super.addTab(title, new CloseTabIcon(extraIcon), component);
	}

	private void tabClicked(MouseEvent e) {
		int index = getUI().tabForCoordinate(this, e.getX(), e.getY());
		Rectangle rect;

		if(index<0) return;
		rect = ((CloseTabIcon)getIconAt(index)).getBounds();
		if(rect.contains(e.getX(), e.getY())) {
			removeTabAt(index);
		}
	}

}

class CloseTabIcon implements Icon {

	private int x_pos;
	private int y_pos;
	private int width;
	private int height;
	private Icon fileIcon;

	public CloseTabIcon(Icon fileIcon) {
		this.fileIcon = fileIcon;
		width = 16;
		height = 16;
	}

	@Override
	public void paintIcon(Component c, Graphics g, int x, int y) {
		Color col=g.getColor();
		int yp;

		this.x_pos = x;
		this.y_pos = y;
		g.setColor(Color.BLACK);
		yp = y + 2;
		g.drawLine(x +  1, yp,      x + 12, yp);
		g.drawLine(x +  1, yp + 13, x + 12, yp + 13);
		g.drawLine(x     , yp +  1, x,      yp + 12);
		g.drawLine(x + 13, yp +  1, x + 13, yp + 12);
		g.drawLine(x +  3, yp +  3, x + 10, yp + 10);
		g.drawLine(x +  3, yp +  4, x +  9, yp + 10);
		g.drawLine(x +  4, yp +  3, x + 10, yp + 9);
		g.drawLine(x + 10, yp +  3, x +  3, yp + 10);
		g.drawLine(x + 10, yp +  4, x +  4, yp + 10);
		g.drawLine(x +  9, yp +  3, x +  3, yp + 9);
		g.setColor(col);
		if(fileIcon != null) {
			fileIcon.paintIcon(c, g, x + width, yp);
		}
	}

	@Override
	public int getIconWidth() {
		return fileIcon != null ?
				width + fileIcon.getIconWidth() : width;
	}

	@Override
	public int getIconHeight() {
		return height;
	}

	public Rectangle getBounds() {
		return new Rectangle(x_pos, y_pos, width, height);
	}

}
