/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.sqlcs.dml;

public class SqlBinaryOperation implements SqlExpression {

	private SqlBinaryOperator op;
	private SqlExpression exa, exb;

	public SqlBinaryOperation(SqlBinaryOperator op, SqlExpression a,
			SqlExpression b) {
		this.op = op;
		exa = a;  exb = b;
	}

	public SqlBinaryOperator getOperator() {
		return op;
	}

	public SqlExpression getOperand1() {
		return exa;
	}

	public SqlExpression getOperand2() {
		return exb;
	}

	@Override
	public int getMaxParameter() {
		return Math.max(exa.getMaxParameter(), exb.getMaxParameter());
	}

	public String toString() {
		return op.toSExpression(exa, exb);
	}

}
