/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.delay;

import net.morilib.db.misc.Rational;

public class KurtosisDelay extends BufferedDelay {

	private static final Rational THREE = Rational.valueOf(3);

	@Override
	public Object force() {
		Rational m = mean(), n, d, x, y, t, s;

		n = d = Rational.ZERO;
		s = Rational.valueOf(values.size());
		for(Rational a : values) {
			t = a.subtract(m);
			x = t.multiply(t);
			y = x.multiply(t).multiply(t);
			n = n.add(y);
			d = d.add(x);
		}
		n = n.divide(s);
		d = d.divide(s);
		return n.divide(d).divide(d).subtract(THREE);
	}

}
