/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.fichier;

import java.io.File;
import java.io.IOException;

public abstract class FabriqueDeFichier {

	private static final FabriqueDeFichier
	_DF = new FabriqueDeFichier() {

		public Fichier newInstance(Fichier dir, String name) {
			return new FileFichier(new File(
					((FileFichier)dir).file, name));
		}

		public Fichier newInstance(String name) {
			return new FileFichier(new File(name));
		}

		public Fichier newInstance(File name) {
			return new FileFichier(name);
		}

		public Fichier createTempFile(String prefix,
				String suffix) throws IOException {
			return new FileFichier(File.createTempFile(prefix,
					suffix));
		}

	};

	public static FabriqueDeFichier getDefault() {
		return _DF;
	}

	/**
	 * 
	 * @param dir
	 * @param name
	 * @return
	 */
	public abstract Fichier newInstance(Fichier dir, String name);

	/**
	 * 
	 * @param name
	 * @return
	 */
	public abstract Fichier newInstance(String name);

	/**
	 * 
	 * @param name
	 * @return
	 */
	public abstract Fichier newInstance(java.io.File name);

	/**
	 * 
	 * @param prefix
	 * @param suffix
	 * @return
	 * @throws IOException
	 */
	public abstract Fichier createTempFile(String prefix,
			String suffix) throws IOException;

}
