/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.fichier;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class ResourceFichier implements Fichier {

	private String loc;

	@Override
	public boolean isFile() {
		return ResourceFichier.class.getResource(loc) != null;
	}

	@Override
	public boolean createNewFile() throws IOException {
		return false;
	}

	@Override
	public Reader openReader() throws IOException {
		return new InputStreamReader(
				ResourceFichier.class.getResourceAsStream(loc));
	}

	@Override
	public Writer openWriter() throws IOException {
		throw new IOException();
	}

	@Override
	public InputStream openInputStream() throws IOException {
		return ResourceFichier.class.getResourceAsStream(loc);
	}

	@Override
	public OutputStream openOutputStream() throws IOException {
		throw new IOException();
	}

	@Override
	public String getName() {
		return loc.replaceFirst("^.*/", "");
	}

	@Override
	public boolean delete() throws IOException {
		return false;
	}

	@Override
	public Fichier[] listFichiers() {
		return null;
	}

	@Override
	public boolean renameTo(Fichier name) throws IOException {
		return false;
	}

}
