package net.morilib.db.info;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import net.morilib.db.jdbc.BeanListResultSet;
import net.morilib.db.schema.SqlSchema;
import net.morilib.db.sqlcs.ddl.SqlColumnAttribute;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;
import net.morilib.db.sqlcs.ddl.SqlCreateTable;

public class PrimaryKeysInfo {

	static final String[] INFO = new String[] {
		"tableCat",
		"tableSchem",
		"tableName",
		"columnName",
		"keySeq",
		"pkName",
	};

	public static BeanListResultSet get(SqlSchema sql,
			String tn) throws IOException, SQLException {
		List<PrimaryKeysInfo> l = new ArrayList<PrimaryKeysInfo>();
		SqlColumnDefinition d;
		PrimaryKeysInfo f;
		SqlCreateTable t;
		short j;

		for(String s : sql.getTableNames()) {
			if(s.equals(tn))  continue;
			t = sql.getCreateTable(s);
			j = 1;
			for(int i = 0; i < t.getColumnDefinitions().size(); i++) {
				d = t.getColumnDefinitions().get(i);
				if(d.getAttributes().contains(
						SqlColumnAttribute.PRIMARY_KEY)) {
					f = new PrimaryKeysInfo();
					f.tableName = s;
					f.columnName = d.getName();
					f.keySeq = j++;
					f.pkName = d.getName();
					l.add(f);
				}
			}
		}
		return new BeanListResultSet(PrimaryKeysInfo.class,
				Arrays.asList(INFO), l);
	}

	private String tableCat;
	private String tableSchem;
	private String tableName;
	private String columnName;
	private short keySeq;
	private String pkName;

	public String getColumnName() {
		return columnName;
	}

	public void setColumnName(String columnName) {
		this.columnName = columnName;
	}

	public String getTableCat() {
		return tableCat;
	}

	public void setTableCat(String tableCat) {
		this.tableCat = tableCat;
	}

	public String getTableSchem() {
		return tableSchem;
	}

	public void setTableSchem(String tableSchem) {
		this.tableSchem = tableSchem;
	}

	public String getTableName() {
		return tableName;
	}

	public void setTableName(String tableName) {
		this.tableName = tableName;
	}

	public short getKeySeq() {
		return keySeq;
	}

	public void setKeySeq(short keySeq) {
		this.keySeq = keySeq;
	}

	public String getPkName() {
		return pkName;
	}

	public void setPkName(String pkName) {
		this.pkName = pkName;
	}

}
