/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.sqlcs.dml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SqlFunction implements SqlExpression {

	//
	private String name;
	private List<SqlExpression> arguments;

	public SqlFunction(String name, List<SqlExpression> args) {
		this.name = name;
		arguments = new ArrayList<SqlExpression>(args);
	}

	public SqlFunction(String name, SqlExpression... args) {
		this(name, Arrays.asList(args));
	}

	public String getName() {
		return name;
	}

	public List<SqlExpression> getArguments() {
		return Collections.unmodifiableList(arguments);
	}

	@Override
	public int getMaxParameter() {
		int j = 0;

		for(SqlExpression e : arguments) {
			j = Math.max(j, e.getMaxParameter());
		}
		return j;
	}

	public String toString() {
		StringBuffer b = new StringBuffer("(");

		b.append(name);
		for(SqlExpression e : arguments) {
			b.append(' ').append(e.toString());
		}
		return b.append(')').toString();
	}

}
