/**
 * JQueryプラグイン：データソースプラグイン
 * 
 * HTMLの入力要素とデータモデルを関連付けるプラグインです
 */
(function($){
	var _datapool = {};
	
	$.fn.datasource = function(options){
		var $$ = $(this);
		var tagObj = $$[0];
		var current = null;
		if(options == null || options == undefined) {
			current = _datapool;
		} else {
			if(options.target == null || options.target == undefined) {
				current = _datapool;
			} else {
				if((typeof options.target) === 'string') {
					if(_datapool[options.target]) {
						
					} else {
						_datapool[options.target] = {};
					}
					current = _datapool[options.target]
				} else {
					current = _datapool;
				}
			}
		}
		
		if(tagObj.tagName === 'INPUT') {
			var type = $$.attr('type');
			
			if(type === 'text' || type === 'date') {
				
				$$.change(function(){
					//console.log(type);
					var id = $(this).attr('id');
					var name = $(this).attr('name');
					var obj = {
							'id':id
						,	'type':'text'
						,	'name':name
						,	'data':{
							'value':$(this).val()
						}
					};
					
					current[id] = obj;
					//console.log(obj);
				});
				
			} else if(type === 'button') {
			} else if(type === 'submit') {
			} else if(type === 'radio') {
				$$.change(function(){
					//console.log(type);
					var id = $(this).attr('id');
					var name = $(this).attr('name');
					var radios = $('[name="' + name + '"]');
					var ctx = {};
					radios.each(function(index, element){
						var el = $(element);
						ctx[el.attr('id')] = {
								'data':el.is(':checked')
							,	'value':el.val()
						};
					});
					
					var obj = {
							'id':name
						,	'type':'radio'
						,	'name':name
						,	'data':ctx
						
					};
					
					current[name] = obj;
					//console.log(obj);
				});

			} else if(type === 'checkbox') {
				$$.change(function(){
					//console.log(type);
					var id = $(this).attr('id');
					var name = $(this).attr('name');
					var checks = $('[name="' + name + '"]');
					var ctx = {};
					checks.each(function(index, element){
						var el = $(element);
						ctx[el.attr('id')] = {
								'data':el.is(':checked')
							,	'value':el.val()
						};
					});
					
					var obj = {
							'id':name
						,	'type':'checkbox'
						,	'name':name
						,	'data':ctx
						
					};
					//console.log(obj);
					current[name] = obj;
				});

			}
		} else if(tagObj.tagName === 'SELECT') {
			var id = $$.attr('id');
			$$.change(function(){
				//console.log('select');
				var id = $(this).attr('id');
				var name = $(this).attr('name');
				var label = $($(this).children("option:selected").get(0)).text();
				
				var obj = {
						'id':id
					,	'type':'select'
					,	'name':name
					,	'data':{
							'name':label
						,	'value':$(this).val()
					}
				};
				//console.log(obj);
				current[id] = obj;
			});
			
		} else if(tagObj.tagName === 'BUTTON') {
			
		} else if(tagObj.tagName === 'TEXTAREA') {
			$$.change(function(){
				//console.log('textarea');
				var id = $(this).attr('id');
				var name = $(this).attr('name');
				var obj = {
						'id':id
					,	'type':'textarea'
					,	'name':name
					,	'data':{
						'value':$(this).val()
					}
				};
				//console.log(obj);
				current[id] = obj;
			});
		} else {
			return $$;
		}
	};
	
	$.getDataSource = function(options){
		if(options == null || options == undefined) {
			return _datapool;
		} else {
			if(options.target == null || options.target == undefined) {
				return _datapool;
			} else {
				if((typeof options.target) === 'string') {
					return _datapool[options.target]
				} else {
					return _datapool;
				}
			}
		}
	};
	
	$.sendDataSource = function(options){
		var current = null;
		if(options == null || options == undefined) {
			current = _datapool;
		} else {
			if(options.target == null || options.target == undefined) {
				current = _datapool;
			} else {
				if((typeof options.target) === 'string') {
					current = _datapool[options.target]
				} else {
					current = _datapool;
				}
			}
		}
		
		if(current) {
			// ターゲットへデータを送信
		}
	};
})(jQuery);