/**
 * JQueryプラグイン：コンテンツオーバレイ
 * Depends On　　　：jquery.depend.js
 * 
 * 任意のDOMエレメントに対してオーバレイを表示するJQueryプラグインです
 */
(function($){
	
	$.fn.overlay = function(options){
		var $$ = $(this);
		var param = [];
		
		
		if(options.mode != null && options.mode != undefined && options.mode != undefined && (typeof options.target.append) === 'function') {
			options.target.append(obj);
		}
		
		param.push("top:" + $$.position().top);
		param.push("left:" + $$.position().left);
		
		param.push("width:" + $$.width());
		param.push("height:" + $$.height());
		
		
		var paramStr = param.join(', ');
		
		var obj = null;
		
		if($$[0].nodeName === 'INPUT' && $$.attr('type') === 'text') {
			
			if($.browser.is("msie")) {
				obj = $("<div id='" + $$.attr('id') + '_overlay' + "'></div>").css({
					"position":"absolute",
					"top":$$.position().top + 1,
					"left":$$.position().left + 1,
					"width":$$.width() + 2,
					"height":$$.height() + 4,
					"backgroundColor":"white",
					"opacity":0.5,
					"lineHeight":$$.height() + 4 + 'px'
				});

			} else if($.browser.is("firefox")) {
				obj = $("<div id='" + $$.attr('id') + '_overlay' + "'></div>").css({
					"position":"absolute",
					"top":$$.position().top + 2,
					"left":$$.position().left + 2,
					"width":$$.width() - 1,
					"height":$$.height() + 4,
					"backgroundColor":"white",
					"opacity":0.5,
					"lineHeight":$$.height() + 4 + 'px'
				});
			} else if($.browser.is("chrome")) {
				obj = $("<div id='" + $$.attr('id') + '_overlay' + "'></div>").css({
					"position":"absolute",
					"top":$$.position().top + 3,
					"left":$$.position().left + 3,
					"width":$$.width(),
					"height":$$.height() + 4,
					"backgroundColor":"white",
					"opacity":0.5,
					"lineHeight":$$.height() + 4 + 'px'
				});
			} else {
				obj = $("<div id='" + $$.attr('id') + '_overlay' + "'></div>").css({
					"position":"absolute",
					"top":$$.position().top + 3,
					"left":$$.position().left + 3,
					"width":$$.width(),
					"height":$$.height() + 4,
					"backgroundColor":"white",
					"opacity":0.5,
					"lineHeight":$$.height() + 4 + 'px'
				});
			}
			obj.click(function(){
				obj.hide();
				$$.focus();
			});
			$$.blur(function(){
				obj.show();
				
				if($$.val() === '') {
					obj.text($$.attr('description'));
				} else {
					obj.text('');
				}
				
			}).change(function(){
				if($$.val() === '') {
					obj.text($$.attr('description'));
				} else {
					obj.text('');
				}
			}).focus(function(){
				obj.hide();
				$(this).text('');
				$$.select();
				
			});
			obj.text($$.attr('description'));
		} else if($$[0].nodeName === 'SELECT') {
			if($.browser.is("msie")) {
				obj = $("<div id='" + $$.attr('id') + '_overlay' + "'></div>").css({
					"position":"absolute",
					"top":$$.position().top + 1,
					"left":$$.position().left,
					"width":$$.width() + 2 - 18,
					"height":$$.height(),
					"backgroundColor":"white",
					"opacity":0.5,
					"lineHeight":$$.height() + 4 + 'px'
				});
			} else {
				obj = $("<div id='" + $$.attr('id') + '_overlay' + "'></div>").css({
					"position":"absolute",
					"top":$$.position().top + 3,
					"left":$$.position().left,
					"width":$$.width() + 2 - 18,
					"height":$$.height() + 1,
					"backgroundColor":"white",
					"opacity":0.5,
					"lineHeight":$$.height() + 4 + 'px'	
				});
			}
		} else {
			obj = $("<div id='" + $$.attr('id') + '_overlay' + "'></div>").css({
				"position":"absolute",
				"top":$$.position().top + 1,
				"left":$$.position().left + 1,
				"width":$$.width() + 1,
				"height":$$.height() + 1,
				"backgroundColor":"white",
				"opacity":0.5
			});
		}
		
		if(options.target != null && options.target != undefined && options.target.append != undefined && (typeof options.target.append) === 'function') {
			if($.browser.is("msie")) {
				options.target.scroll(function(e){
					obj.css({
						"top":$$.position().top
					});
				});
			} else {
				options.target.scroll(function(e){
					obj.css({
						"top":$$.position().top + 2
					});
				});
			}

			options.target.append(obj);
		}
		
		return $$;
	};
	
	$.fn.removeOverlay = function(options){
		var $$ = $(this);
		var param = [];
		
		
		var target = $('#' + $$.attr('id') + '_overlay');
		
		if(target != null) {
			target.remove();
		}
		
		return $$;
	};
})(jQuery);