﻿using System;
using System.IO;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using Twitter;
namespace Quicker
{
    public partial class FormTweet : Form
    {
        const string FormTitle = "いまなにしてんの？ あと";

        /// <summary>
        /// 設定情報
        /// </summary>
        Settings Settings_;

        public FormTweet(Settings settings)
        {
            InitializeComponent();

            Settings_ = settings;

            // タイトルの設定
            this.Text = FormTitle + textBoxMessage.MaxLength.ToString() + "文字";
        }

        private void buttonCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void FormTweet_Load(object sender, EventArgs e)
        {
            this.Activate();
        }

        private void buttonTweet_Click(object sender, EventArgs e)
        {
            if (textBoxMessage.Text == "")
            {
                return;
            }
            textBoxMessage.Enabled = false;
            this.Text = "ついっと中";
            TwitterClient tc = new TwitterClient(Settings_.Acount, Settings_.Password);
            if (!tc.UpdateStatus(textBoxMessage.Text))
            {
                MessageBox.Show("つぶやけませんでした。設定を確認してください", "Quicker");
            }
            this.Close();
        }

        private void textBoxMessage_TextChanged(object sender, EventArgs e)
        {
            this.Text = "いまなにしてんの？ あと" + (textBoxMessage.MaxLength - textBoxMessage.TextLength).ToString() + "文字";
        }

        private void FormTweet_Shown(object sender, EventArgs e)
        {
            if (Settings_.Acount == "" || Settings_.Password == "")
            {
                MessageBox.Show("アカウントが設定されていません", "Quicker");
                this.Close();
            }
        }
    }
}
