﻿using System;
using System.IO;
using System.Collections.Generic;
using System.Text;
using System.Net;
using System.Xml;

using System.Security.Cryptography;


namespace Twitter
{
    public class TwitterClient
    {
        /// <summary>
        /// アカウント
        /// </summary>
        string Acount_;
        public string Acount
        {
            private set{    Acount_ = value;    }
            get{    return Acount_;     }
        }

        /// <summary>
        /// パスワード
        /// </summary>
        string Password_;
        public string Password {
            private set{    Password_ = value;  }
            get{    return Password_;   }
        }

        /// <summary>
        /// クライアント名
        /// </summary>
        string ClientName_ = "";
        public string ClientName
        {
            private set { ClientName_ = value; }
            get { return ClientName_; }
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="acount">アカウント</param>
        /// <param name="password">パスワード</param>
        public TwitterClient(string acount, string password)
        {
            Acount = acount;
            Password = password;
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="acount">アカウント</param>
        /// <param name="password">パスワード</param>
        /// <param name="clientName">クライアント名(要:Twitterサーバー側への登録)通常は""</param>
        public TwitterClient(string acount, string password, string clientName)
            : this( acount, password)
        {
            ClientName = clientName;
        }

        /// <summary>
        /// 接続できるか確認する。
        /// </summary>
        /// <returns></returns>
        public bool CanConnect()
        {
            WebRequest req = CreateWebRequest("http://twitter.com/account/rate_limit_status.xml");
            req.Method = "GET";
            try
            {
                HttpWebResponse wr = (HttpWebResponse)req.GetResponse();
                HttpStatusCode ht = wr.StatusCode;
                wr.Close();
                return ht == HttpStatusCode.OK;
            }
            catch
            {
                return false;
            }
        }

        /// <summary>
        /// 発言する
        /// </summary>
        /// <param name="status">発言内容</param>
        /// <returns>結果</returns>
        public bool UpdateStatus(string status)
        {
            byte[] postValue = CreatePostValue(status);
            WebRequest req = CreateWebRequest("http://twitter.com/statuses/update.xml");
            req.Method = "POST";
            req.ContentLength = postValue.Length;

            try
            {
                using (Stream strm = req.GetRequestStream())
                {
                    strm.Write(postValue, 0, postValue.Length);
                }
            }
            catch (Exception ex)
            {
                Console.Write(ex.Message);
                //接続エラー
                return false;
            }
            HttpWebResponse result = null;
            try
            {
                result = (HttpWebResponse)req.GetResponse();
                return result.StatusCode == HttpStatusCode.OK;
            }
            catch (WebException ex)
            {
                //認証のエラー
                Console.Write(ex.Message);
                return false;
            }
            catch (Exception ex)
            {
                //それ以外のエラー
                Console.Write(ex.Message);
                return false;
            }
        }


        /// <summary>
        /// urlからリクエストを作成する
        /// </summary>
        /// <param name="uri"></param>
        /// <returns></returns>
        private WebRequest CreateWebRequest(string uri)
        {
            WebRequest req = HttpWebRequest.Create(uri);
            req.ContentType = "application/x-www-form-urlencoded";
            req.Headers.Add(CreateAuthString());
            req.Timeout = 10000;
            ServicePointManager.Expect100Continue = false;
            return req;
        }

        /// <summary>
        /// Basic認証用の文字列を作成する
        /// </summary>
        /// <returns></returns>
        private string CreateAuthString()
        {
            return "Authorization: Basic " + Convert.ToBase64String(Encoding.ASCII.GetBytes(Acount + ":" + Password));
        }

        /// <summary>
        /// 発言する内容を作成する
        /// </summary>
        /// <param name="status"></param>
        /// <returns></returns>
        private byte[] CreatePostValue(string status)
        {
            return Encoding.ASCII.GetBytes(/*"source=" + Uri.EscapeUriString(ClientName_) +*/ "status=" + Uri.EscapeUriString(status));
        }

    }
}
