<?php
/**
 * ログアウト画面クラス
 *
 * ログアウト画面を実現するためのクラス
 *
 * @package   risoluto
 * @author    Yuta Hayakawa <haya@hyec.org>
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2009 Yuta Hayakawa / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( 'admin_base.inc' );

  class logout extends admin_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // スーパバイザセッション又はアドミンセッションが存在しない場合は、
      // ログイン画面に遷移する
      if ( ! $this->obj_util->is_Admin() )
      {
        $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'login_act'  )
                                   , $this->obj_adminconf->get( 'COMMON', 'login_cage' ) );
        return false;
      } // end of if

      // セッションを消す
      $this->obj_sess->sessRevoke( 'login_userid'  );
      $this->obj_sess->sessRevoke( 'login_groupid' );
      $this->obj_sess->sessEnd();

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // ヘッダ情報をセット
      $html_header[ 'robots' ] = 'NOINDEX,NOFOLLOW';
      $html_header[ 'title'  ] = 'ログアウト';

      // アサイン
      $this->smarty->assign ( 'header',     $html_header  );
      $this->smarty->assign ( 'login_cage', $this->obj_adminconf->get( 'COMMON', 'login_cage' ) );
      $this->smarty->assign ( 'login_act',  $this->obj_adminconf->get( 'COMMON', 'login_act'  ) );

      // 表示
      $this->smarty->display( 'logout.tpl' );

      return true;

    } // end of function:view()

  } // end of class:logout
?>
