<?php
/**
 * ヘッダ削除対象選択画面クラス
 *
 * ヘッダ削除対象選択画面を実現するためのクラス
 *
 * @package   risoluto
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2009 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "admin_site_base.inc" );
  /**
   * データベース操作クラス
   */
  require_once( RISOLUTO_FUNC . 'risoluto_db.php' );

  class headerdel_select extends admin_site_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * データベース操作クラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_db;
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_conf;
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 必要なインスタンスを生成
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . 'risoluto.ini' );

      // スーパバイザセッション又はアドミンセッションが存在しない場合は、
      // ログイン画面に遷移する
      if ( ! $this->obj_util->is_Admin() )
      {
        $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'login_act'  )
                                   , $this->obj_adminconf->get( 'COMMON', 'login_cage' ) );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // ユーザ情報の取得
      //------------------------------------------------------------------------

      // データベースに接続する
      // データベース操作クラスのインスタンスを生成する
      $this->obj_db = new RisoluteDb();

      // データベースに接続する
      if ( $this->obj_db->dbConnect( $this->obj_conf->get( 'DBS', 'DEFAULT_DSN' ) ) )
      {
        // SQL文を組み立てる
        $sql =<<<End_Of_SQL

              SELECT `headers`.`header_id` -- ヘッダID
                   , `headers`.`act`       -- Act
                   , `headers`.`cage`      -- Cage
                FROM `risoluto_t_headerinfo` headers
               WHERE `headers`.`header_id` > 0
            ORDER BY `headers`.`header_id` ASC

End_Of_SQL;

        // パラメタも用意する
        $param = array(
                      );

        // SQLの実行に失敗した場合は、例外を投げる
        $tmp_result = $this->obj_db->dbGetAll( $sql, $param );
        if ( PEAR::isError( $tmp_result ) )
        {
          // 接続をクローズする
          $this->obj_db->dbDisConnect();
          throw new Exception( 'headerlist get Failure' );
          return false;
        } // end of if

        // 接続に成功している場合は接続をクローズする
        $this->obj_db->dbDisConnect();
      } // end of if
      // データベースに接続できなかった場合は、例外を投げる
      else
      {
        throw new Exception( 'DB Connection Failure' );
        return false;
      } // end of else

      // 取得した値を適切な形式に加工
      foreach( $tmp_result as $dat )
      {
        $this->gotDat[ 'headerlist' ][ $dat[ 'header_id' ] ] = $dat[ 'cage' ] . '/' . $dat[ 'act' ];
      } // end of foreach



      //------------------------------------------------------------------------
      // セッション情報の取得
      //------------------------------------------------------------------------

      // セッションからエラーメッセージと入力値を取得し、削除する
      $this->gotDat[ 'errMsg' ] = $this->obj_sess->sessLoad( $this->obj_sess->sessLoad( 'currentact' ) );
      $this->obj_sess->sessRevoke( $this->obj_sess->sessLoad( 'currentact' ) );

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // アサイン
      $this->smarty->assign ( 'header',         $this->obj_util->getHeader() );

      $this->smarty->assign ( 'menu_cage',      $this->obj_adminconf->get( 'COMMON', 'menu_cage' ) );
      $this->smarty->assign ( 'menu_act',       $this->obj_adminconf->get( 'COMMON', 'menu_act'  ) );

      $this->smarty->assign ( 'headerlist',     $this->gotDat[ 'headerlist' ] );

      // 表示
      $this->smarty->display( 'headerdel_select.tpl' );

      return true;

    } // end of function:view()

  } // end of class:headerdel_select

?>
