/* simpleblog関連テーブル */

CREATE TABLE IF NOT EXISTS [[[_PREFIX]]]_t_blog
(
      `ctime`              datetime       NOT NULL
    , `cuser`              varchar(255)   NOT NULL
    , `mtime`              datetime       NOT NULL
    , `muser`              varchar(255)   NOT NULL
    , `user_id`            int unsigned   NOT NULL
    , `blog_id`            int unsigned   NOT NULL
    , `blog_title`         varchar(255)
    , `blog_body`          text
    , `open_datetime`      DATETIME
    , `end_datetime`       DATETIME
    , `post_datetime`      DATETIME
    , PRIMARY KEY  (
                     `user_id`
                   , `blog_id`
                   )
) ENGINE=InnoDB CHARACTER SET utf8;

CREATE TABLE IF NOT EXISTS [[[_PREFIX]]]_t_comment
(
      `ctime`              datetime       NOT NULL
    , `cuser`              varchar(255)   NOT NULL
    , `mtime`              datetime       NOT NULL
    , `muser`              varchar(255)   NOT NULL
    , `comment_id`         int unsigned   NOT NULL
    , `blog_id`            int unsigned   NOT NULL
    , `commentator`        varchar(255)
    , `comment`            text
    , `status`             int unsigned
    , PRIMARY KEY  (
                     `comment_id`
                   , `blog_id`
                   )
) ENGINE=InnoDB CHARACTER SET utf8;

CREATE TABLE IF NOT EXISTS [[[_PREFIX]]]_t_trackback
(
      `ctime`              datetime       NOT NULL
    , `cuser`              varchar(255)   NOT NULL
    , `mtime`              datetime       NOT NULL
    , `muser`              varchar(255)   NOT NULL
    , `trackback_id`       int unsigned   NOT NULL
    , `blog_id`            int unsigned   NOT NULL
    , `url`                text           NOT NULL
    , `blogname`           text
    , `title`              text
    , `body`               text
    , `status`             int unsigned
    , PRIMARY KEY  (
                     `trackback_id`
                   , `blog_id`
                   )
) ENGINE=InnoDB CHARACTER SET utf8;
