<?php
/**
 * カテゴリ情報変更情報入力画面クラス
 *
 * カテゴリ情報変更情報入力画面を実現するためのクラス
 *
 * @package   simpleblog
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2011 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "simpleblog_base.inc" );
  /**
   * データベース操作クラス
   */
  require_once( RISOLUTO_FUNC . 'risoluto_db.php' );

  class categorymod_entry extends simpleblog_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * データベース操作クラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_db;
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_conf;
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 必要なインスタンスを生成
      $this->obj_db   = new RisolutoDb();
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . 'risoluto.ini' );

      // スーパバイザセッション又はアドミンセッションが存在しない場合は、
      // ログイン画面に遷移する
      if ( ! $this->obj_util->is_Admin() )
      {
        $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'login_act'  )
                                   , $this->obj_adminconf->get( 'COMMON', 'login_cage' ) );
        return false;
      } // end of if

      // 前画面のCageが自分と同じでない or 前画面のActが「categorylist」または「blogview」または「categorymod_confirm」でない場合、
      // 入力画面に飛ばす
      $tmp_cage_last    = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage'    ) );
      $tmp_cage_current = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'currentcage' ) );

      $tmp_act  = $this->obj_sess->sessLoad( 'lastact'  );
      if ( ( $tmp_cage_last != $tmp_cage_current ) or ( $tmp_act != 'categorylist' and $tmp_act != 'categorymod_confirm' ) )
      {
        $this->obj_util->redirectTo( 'categorylist', $tmp_cage_current );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // セッション情報の取得
      //------------------------------------------------------------------------
      // 前画面のActが「categorymod_confirm」なら、必要な情報をセッションから取得する
      if ( $tmp_act == 'categorymod_confirm' )
      {
        // セッションからエラーメッセージと入力値を取得し、削除する
        $tmp_entered = $this->obj_sess->sessLoad( $this->obj_sess->sessLoad( 'currentcage' ) );
        $this->obj_sess->sessRevoke( $this->obj_sess->sessLoad( 'currentcage' ) );

        // 表示に必要な加工を行う
        $this->gotDat[ 'errMsg' ][ 'message'      ] = $tmp_entered[ 'errMsg' ][ 'message'      ];
        $this->gotDat[ 'errMsg' ][ 'categoryid'   ] = $tmp_entered[ 'errMsg' ][ 'categoryid'   ];
        $this->gotDat[ 'errMsg' ][ 'categoryname' ] = $tmp_entered[ 'errMsg' ][ 'categoryname' ];

        return true;
      } // end of if


      //------------------------------------------------------------------------
      // 前画面の入力値を取得
      //------------------------------------------------------------------------
      // 初期化
      $tmp_entered[ 'errMsg' ][ 'categoryid' ] = null;

      // ブログID
      if ( isset( $_GET[ 'categoryid' ] ) )
      {
        $tmp_entered[ 'errMsg' ][ 'categoryid' ] = strip_tags( trim( $_GET[ 'categoryid' ] ) );
      } // end of if



      //------------------------------------------------------------------------
      // 入力情報のチェック
      //------------------------------------------------------------------------
      // 渡されてきたカテゴリIDが数字でなければ、カテゴリ一覧画面に遷移する
      if ( empty( $tmp_entered[ 'errMsg' ][ 'categoryid' ] ) or ! is_numeric( $tmp_entered[ 'errMsg' ][ 'categoryid' ] ) )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'errMsg' ][ 'message' ] = 'invalid_categoryid';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered );
        $this->obj_util->redirectTo( 'categorylist', $tmp_cage_current );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // ブログ記事情報の取得
      //------------------------------------------------------------------------

      // データベースに接続する
      if ( $this->obj_db->dbConnect( $this->obj_conf->get( 'DBS', 'DEFAULT_DSN' ) ) )
      {

        // ユーザ情報を取得する
        // SQL文を組み立てる
        $tmp_t_category = $this->mycage . '_t_category';
        $sql =<<<End_Of_SQL

              SELECT  `cat`.`category_id`   -- ブログID
                    , `cat`.`category_name` -- ブログタイトル
                FROM $tmp_t_category cat
               WHERE `cat`.`category_id` = ?

End_Of_SQL;

        // パラメタも用意する
        $param = array(
                        $tmp_entered[ 'errMsg' ][ 'categoryid' ]
                      );

        // SQLの実行に失敗した場合は、例外を投げる
        $tmp_categorydat = $this->obj_db->dbGetRow( $sql, $param );
        if ( PEAR::isError( $tmp_categorydat ) )
        {
          // 接続をクローズする
          $this->obj_db->dbDisConnect();
          throw new Exception( 'category information get Failure' );
          return false;
        } // end of if
        // 正常に取得できていれば、クラス変数にセットする
        else
        {
          // 接続をクローズする
          $this->obj_db->dbDisConnect();
          $this->gotDat[ 'errMsg' ][ 'message'      ] = null;
          $this->gotDat[ 'errMsg' ][ 'categoryid'   ] = $tmp_categorydat[ 'category_id'    ];
          $this->gotDat[ 'errMsg' ][ 'categoryname' ] = $tmp_categorydat[ 'category_name' ];
        } // end of else

      } // end of if
      // データベースに接続できなかった場合は、例外を投げる
      else
      {
        throw new Exception( 'DB Connection Failure' );
        return false;
      } // end of else



      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // アサイン
      $this->smarty->assign ( 'header',                $this->obj_util->getHeader() );

      $this->smarty->assign ( 'menu_cage',             $this->obj_adminconf->get( 'COMMON', 'menu_cage' ) );
      $this->smarty->assign ( 'menu_act',              $this->obj_adminconf->get( 'COMMON', 'menu_act'  ) );

      $this->smarty->assign ( 'mycage',                $this->mycage );

      $this->smarty->assign ( 'errMsg',                $this->gotDat[ 'errMsg' ][ 'message'      ] );
      $this->smarty->assign ( 'entered_categoryid',    $this->gotDat[ 'errMsg' ][ 'categoryid'   ] );
      $this->smarty->assign ( 'entered_categoryname',  $this->gotDat[ 'errMsg' ][ 'categoryname' ] );

      // 表示
      $this->smarty->display( 'categorymod_entry.tpl' );

      return true;

    } // end of function:view()

  } // end of class:pageadd_entry

?>
