<?php
/**
 * アップグレードFlavor画面(6)クラス
 *
 * アップグレードFlavor画面(6)を実現するためのクラス
 *
 * @package   risoluto
 * @author    Yuta Hayakawa <haya@hyec.org>
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2009 Yuta Hayakawa / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( 'upgrade_base.inc' );

  class page05 extends upgrade_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * チェック情報格納用変数
     * @access private
     * @var    array
     */
    private $checklist;
    /**
     * チェック結果格納用変数
     * @access private
     * @var    array
     */
    private $checkresult;
    /**
     * エラー発生状況格納用変数
     * @access private
     * @var    boolean
     */
    private $errStatus;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 前画面のCageが現在のCageと同一でない  or 前画面のActが「page04」 and 「page05」 and 「page06」でない場合、
      // インストーラトップに飛ばす
      $tmp_cage      = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage' ) );
      $tmp_cage_self = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'currentcage' ) );
      $tmp_act       = $this->obj_sess->sessLoad( 'lastact'  );
      if ( $tmp_cage != $tmp_cage_self or ( $tmp_act != 'page04' and $tmp_act != 'page05' and $tmp_act != 'page06' ) )
      {
        $this->obj_util->redirectTo( 'upgrade', $tmp_cage_self );
        return false;
      } // end of if

      // 配置対象をセットする
      // 他に配置する対象があれば、この配列に加えてください。
      // target: 対象ファイル名 / destination: 配置先のパス/パーミッション/オーナ名/グループ名） / 
      // operation: 操作の内容(copy/move/unlink/mkdir/rmdir)
      $this->filelist = array(
                                array(
                                       'target'      => RISOLUTO_USERLAND . 'admin/menu/00001_admin.user.tpl'
                                     , 'destination' => ''
                                     , 'operation'   => 'unlink'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'admin/menu/00002_admin.site.tpl'
                                     , 'destination' => ''
                                     , 'operation'   => 'unlink'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/common.css'
                                     , 'destination' => RISOLUTO_DOCROOT . '/css/common.css'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/risoluto_db.php'
                                     , 'destination' => RISOLUTO_FUNC . 'risoluto_db.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/risoluto_session.php'
                                     , 'destination' => RISOLUTO_FUNC . 'risoluto_session.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/risoluto_util.php'
                                     , 'destination' => RISOLUTO_FUNC . 'risoluto_util.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/menu.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/menu.tpl'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/00002_admin.user.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/menu/00002_admin.user.tpl'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/00003_admin.site.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/menu/00003_admin.site.tpl'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/headermod_entry.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/headermod_entry.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/upload_add.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/upload_add.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/upload_del.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/upload_del.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/uploadlist.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/uploadlist.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/uploadlist.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/uploadlist.tpl'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/uploadviewer.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/site/uploadviewer.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/useradd_confirm.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/useradd_confirm.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/usermod_confirm.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/usermod_confirm.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/usermod_confirm.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/usermod_confirm.tpl'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/groupadd_complete.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/groupadd_complete.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/groupadd_complete.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/groupadd_complete.tpl'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/groupadd_confirm.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/groupadd_confirm.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/groupadd_confirm.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/groupadd_confirm.tpl'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/groupadd_entry.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/groupadd_entry.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/groupadd_entry.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/groupadd_entry.tpl'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/groupdel_complete.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/groupdel_complete.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/groupdel_complete.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/groupdel_complete.tpl'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/groupdel_confirm.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/groupdel_confirm.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/groupdel_confirm.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/groupdel_confirm.tpl'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/grouplist.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/grouplist.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/grouplist.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/grouplist.tpl'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/groupmod_complete.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/groupmod_complete.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/groupmod_complete.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/groupmod_complete.tpl'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/groupmod_confirm.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/groupmod_confirm.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/groupmod_confirm.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/groupmod_confirm.tpl'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/groupmod_entry.php'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/groupmod_entry.php'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/groupmod_entry.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'admin/user/groupmod_entry.tpl'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/admin_footer.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'common/admin_footer.tpl'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/admin_header.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'common/admin_header.tpl'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/footer.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'common/footer.tpl'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/header.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'common/header.tpl'
                                     , 'operation'   => 'copy'
                                     )
                              , array(
                                       'target'      => RISOLUTO_USERLAND . 'upgrade/risoluto-1_0_0_to_risoluto-1_1_0/file/welcome.tpl'
                                     , 'destination' => RISOLUTO_USERLAND . 'welcome/welcome.tpl'
                                     , 'operation'   => 'copy'
                                     )
                             );

      // 処理を行う
      foreach( $this->filelist as $dat )
      {

        // 処理を呼び出す
        $tmp_errflag = $this->obj_util->fileOperator( $dat[ 'operation' ], $dat[ 'target' ], $dat[ 'destination' ] );

        // 処理結果によって、状態を変える
        if ( ! $tmp_errflag )
        {
          $this->checkresult[] = array(
                                        'operation'   => $dat[ 'operation'   ]
                                      , 'target'      => $dat[ 'target'      ]
                                      , 'destination' => $dat[ 'destination' ]
                                      , 'result'  => 'OK'
                                      );
        } // end of if
        else
        {
          $this->checkresult[] = array(
                                        'operation'   => $dat[ 'operation'   ]
                                      , 'target'      => $dat[ 'target'      ]
                                      , 'destination' => $dat[ 'destination' ]
                                      , 'result'  => 'NG'
                                      );
          $this->errStatus     = 'NG';
        } // end of else
      } // end of foreach

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // ヘッダ情報をセット
      $html_header[ 'robots' ] = 'NOINDEX,NOFOLLOW';
      $html_header[ 'css'    ] = array( './css/common.css' );
      $html_header[ 'title'  ] = 'アップグレードFlavor(5)';

      // アサイン
      $this->smarty->assign ( 'header',    $html_header       );
      $this->smarty->assign ( 'checklist', $this->checkresult );
      $this->smarty->assign ( 'err',       $this->errStatus   );

      $this->smarty->assign ( 'cage',   str_replace( DIRECTORY_SEPARATOR, '.' , $this->obj_sess->sessLoad( 'currentcage' ) ) );

      // 表示
      $this->smarty->display( 'page05.tpl' );

      return true;

    } // end of function:view()

  } // end of class:page05
?>
