<?php
/**
 * アップグレードFlavor画面(2)クラス
 *
 * アップグレードFlavor画面(2)を実現するためのクラス
 *
 * @package   risoluto
 * @author    Yuta Hayakawa <haya@hyec.org>
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2011 Yuta Hayakawa / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( 'upgrade_base.inc' );

  class page02 extends upgrade_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * チェック情報格納用変数
     * @access private
     * @var    array
     */
    private $checklist;
    /**
     * チェック結果格納用変数
     * @access private
     * @var    array
     */
    private $checkresult;
    /**
     * エラー発生状況格納用変数
     * @access private
     * @var    boolean
     */
    private $errStatus;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 前画面のCageが現在のCageと同一でない or 前画面のActが「page01」and「page02」and「page03」でない場合、
      // アップグレードFlavorトップに飛ばす
      $tmp_cage      = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage' ) );
      $tmp_cage_self = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'currentcage' ) );
      $tmp_act       = $this->obj_sess->sessLoad( 'lastact'  );
      if ( $tmp_cage != $tmp_cage_self or  ( $tmp_act != 'page01' and $tmp_act != 'page02' and $tmp_act != 'page03' ) )
      {
        $this->obj_util->redirectTo( 'upgrade', $tmp_cage_self );
        return false;
      } // end of if

      // チェック対象をセットする
      // 他にチェック対象があれば、この配列に加えてください。
      // section: セクション名 / key: キー名
      $this->checklist = array(
                                array(
                                       'section' => 'DBS'
                                     , 'key'     => 'DEFAULT_DSN'
                                     )
                              );

      // 値が取得できるかをチェック
      foreach( $this->checklist as $dat )
      {

        // コンフィグから値を取得し、値をチェックする
        $tmp_val = $this->obj_conf->get( $dat[ 'section' ], $dat[ 'key' ] );
        if ( ! empty( $tmp_val ) )
        {
          $this->checkresult[] = array(
                                        'section' => $dat[ 'section' ]
                                      , 'key'     => $dat[ 'key'     ]
                                      , 'result'  => 'OK'
                                      );
        } // end of if
        else
        {
          $this->checkresult[] = array(
                                        'section' => $dat[ 'section' ]
                                      , 'key'     => $dat[ 'key'     ]
                                      , 'result'  => 'NG'
                                      );
          $this->errStatus     = 'NG';
        } // end of else
      } // end of foreach

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // ヘッダ情報をセット
      $html_header[ 'robots' ] = 'NOINDEX,NOFOLLOW';
      $html_header[ 'css'    ] = array( './css/common.css' );
      $html_header[ 'title'  ] = 'アップグレードFlavor(2)';

      // アサイン
      $this->smarty->assign ( 'header',    $html_header       );
      $this->smarty->assign ( 'checklist', $this->checkresult );
      $this->smarty->assign ( 'err',       $this->errStatus   );

      $this->smarty->assign ( 'cage',   str_replace( DIRECTORY_SEPARATOR, '.' , $this->obj_sess->sessLoad( 'currentcage' ) ) );

      // 表示
      $this->smarty->display( 'page02.tpl' );

      return true;

    } // end of function:view()

  } // end of class:page02
?>
