<?php
/**
 * ヘッダ変更情報入力画面クラス
 *
 * ヘッダ変更情報入力画面を実現するためのクラス
 *
 * @package   risoluto
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2011 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "admin_site_base.inc" );
  /**
   * データベース操作クラス
   */
  require_once( RISOLUTO_FUNC . 'risoluto_db.php' );

  class headermod_confirm extends admin_site_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // スーパバイザセッション又はアドミンセッションが存在しない場合は、
      // ログイン画面に遷移する
      if ( ! $this->obj_util->is_Admin() )
      {
        $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'login_act'  )
                                   , $this->obj_adminconf->get( 'COMMON', 'login_cage' ) );
        return false;
      } // end of if

      // 前画面のCageが「admin.site」でない or 前画面のActが「headermod_entry」でない場合、
      // 入力画面に飛ばす
      $tmp_cage = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage' ) );
      $tmp_act  = $this->obj_sess->sessLoad( 'lastact'  );
      if ( $tmp_cage != 'admin.site' or ( $tmp_act != 'headermod_entry' ) )
      {
        $this->obj_util->redirectTo( 'headerlist', 'admin.site' );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // 前画面の入力値を取得
      //------------------------------------------------------------------------
      // 初期化
      $tmp_entered[ 'header_id'    ] = null;
      $tmp_entered[ 'act'          ] = null;
      $tmp_entered[ 'cage'         ] = null;
      $tmp_entered[ 'robot_index'  ] = null;
      $tmp_entered[ 'robot_follow' ] = null;
      $tmp_entered[ 'title'        ] = null;
      $tmp_entered[ 'description'  ] = null;
      $tmp_entered[ 'keywords'     ] = null;
      $tmp_entered[ 'author'       ] = null;
      $tmp_entered[ 'javascript'   ] = null;
      $tmp_entered[ 'css'          ] = null;
      $tmp_entered[ 'favicon'      ] = null;

      // header_id
      if ( isset( $_POST[ 'header_id' ] ) )
      {
        $tmp_entered[ 'header_id' ] = strip_tags( trim( $_POST[ 'header_id' ] ) );
      } // end of if

      // act
      if ( isset( $_POST[ 'act' ] ) )
      {
        $tmp_entered[ 'act' ] = strip_tags( trim( $_POST[ 'act' ] ) );
      } // end of if

      // cage
      if ( isset( $_POST[ 'cage' ] ) )
      {
        $tmp_entered[ 'cage' ] = strip_tags( trim( $_POST[ 'cage' ] ) );
      } // end of if

      // robot_index
      if ( isset( $_POST[ 'robot_index' ] ) )
      {
        $tmp_entered[ 'robot_index' ] = strip_tags( trim( $_POST[ 'robot_index' ] ) );
      } // end of if

      // robot_follow
      if ( isset( $_POST[ 'robot_follow' ] ) )
      {
        $tmp_entered[ 'robot_follow' ] = strip_tags( trim( $_POST[ 'robot_follow' ] ) );
      } // end of if

      // title
      if ( isset( $_POST[ 'title' ] ) )
      {
        $tmp_entered[ 'title' ] = strip_tags( trim( $_POST[ 'title' ] ) );
      } // end of if

      // description
      if ( isset( $_POST[ 'description' ] ) )
      {
        $tmp_entered[ 'description' ] = strip_tags( trim( $_POST[ 'description' ] ) );
      } // end of if

      // keywords
      if ( isset( $_POST[ 'keywords' ] ) )
      {
        $tmp_entered[ 'keywords' ] = strip_tags( trim( $_POST[ 'keywords' ] ) );
      } // end of if

      // author
      if ( isset( $_POST[ 'author' ] ) )
      {
        $tmp_entered[ 'author' ] = strip_tags( trim( $_POST[ 'author' ] ) );
      } // end of if

      // javascript
      if ( isset( $_POST[ 'javascript' ] ) )
      {
        $tmp_entered[ 'javascript' ] = strip_tags( trim( $_POST[ 'javascript' ] ) );
      } // end of if

      // css
      if ( isset( $_POST[ 'css' ] ) )
      {
        $tmp_entered[ 'css' ] = strip_tags( trim( $_POST[ 'css' ] ) );
      } // end of if

      // favicon
      if ( isset( $_POST[ 'favicon' ] ) )
      {
        $tmp_entered[ 'favicon' ] = strip_tags( trim( $_POST[ 'favicon' ] ) );
      } // end of if

      //------------------------------------------------------------------------
      // 入力情報のチェック
      //------------------------------------------------------------------------
      // Act
      if ( ! preg_match( "/^[[:alnum:].\-_]{1,255}$/", $tmp_entered[ 'act' ] ) )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_act';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), $tmp_entered );
        $this->obj_util->redirectTo( 'headermod_entry', 'admin.site' );
        return false;
      } // end of if

      // Cage
      if ( ! preg_match( "/^[[:alnum:].\-_]{0,255}$/", $tmp_entered[ 'cage' ] ) )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_cage';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), $tmp_entered );
        $this->obj_util->redirectTo( 'headermod_entry', 'admin.site' );
        return false;
      } // end of if

      // robots(index)
      if ( $tmp_entered[ 'robot_index' ] != 0 and $tmp_entered[ 'robot_index' ] != 1 )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_robot_index';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), $tmp_entered );
        $this->obj_util->redirectTo( 'headermod_entry', 'admin.site' );
        return false;
      } // end of if

      // robots(follow)
      if ( $tmp_entered[ 'robot_follow' ] != 0 and $tmp_entered[ 'robot_follow' ] != 1 )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_robot_follow';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), $tmp_entered );
        $this->obj_util->redirectTo( 'headermod_entry', 'admin.site' );
        return false;
      } // end of if

      // title
      if ( strlen( $tmp_entered[ 'title' ] ) > 10000 )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_title';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), $tmp_entered );
        $this->obj_util->redirectTo( 'headermod_entry', 'admin.site' );
        return false;
      } // end of if

      // description
      if ( strlen( $tmp_entered[ 'description' ] ) > 10000 )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_description';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), $tmp_entered );
        $this->obj_util->redirectTo( 'headermod_entry', 'admin.site' );
        return false;
      } // end of if

      // keywords
      if ( strlen( $tmp_entered[ 'keywords' ] ) > 10000 )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_keywords';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), $tmp_entered );
        $this->obj_util->redirectTo( 'headermod_entry', 'admin.site' );
        return false;
      } // end of if

      // author
      if ( strlen( $tmp_entered[ 'author' ] ) > 10000 )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_author';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), $tmp_entered );
        $this->obj_util->redirectTo( 'headermod_entry', 'admin.site' );
        return false;
      } // end of if

      // javascript
      if ( strlen( $tmp_entered[ 'javascript' ] ) > 10000 )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_javascript';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), $tmp_entered );
        $this->obj_util->redirectTo( 'headermod_entry', 'admin.site' );
        return false;
      } // end of if

      // css
      if ( strlen( $tmp_entered[ 'css' ] ) > 10000 )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_css';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), $tmp_entered );
        $this->obj_util->redirectTo( 'headermod_entry', 'admin.site' );
        return false;
      } // end of if

      // favicon
      if ( strlen( $tmp_entered[ 'favicon' ] ) > 10000 )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_favicon';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), $tmp_entered );
        $this->obj_util->redirectTo( 'headermod_entry', 'admin.site' );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // 特に問題がなければ、画面表示用にクラス変数とセッションに値をセットする
      //------------------------------------------------------------------------
      $this->gotDat = $tmp_entered;
      $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered );

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // アサイン
      $this->smarty->assign ( 'header',  $this->obj_util->getHeader() );

      $this->smarty->assign ( 'entered', $this->gotDat );

      // 表示
      $this->smarty->display( 'headermod_confirm.tpl' );

      return true;

    } // end of function:view()

  } // end of class:headermod_confirm

?>
