<?php
/**
 * アップグレードFlavor画面(finish)クラス
 *
 * アップグレードFlavor画面(finish)を実現するためのクラス
 *
 * @package   risoluto
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2012 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( 'upgrade_base.inc' );

  class finish extends upgrade_base
  {
    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 前画面のCageが現在のCageと同一でないor 前画面のActが「page06」でない場合、
      // インストーラトップに飛ばす
      $tmp_cage      = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage' ) );
      $tmp_cage_self = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'currentcage' ) );
      $tmp_act       = $this->obj_sess->sessLoad( 'lastact'  );
      if ( $tmp_cage != $tmp_cage_self or $tmp_act != 'page06' )
      {
        $this->obj_util->redirectTo( 'upgrade', $tmp_cage_self );
        return false;
      } // end of if

      // ignoreファイルを作成する
      $this->obj_util->fileOperator( 'make', RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' ) . '/ignore' );

      // セッションを切る
      $this->obj_sess->sessEnd();

      return true;

    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // ヘッダ情報をセット
      $html_header[ 'robots' ] = 'NOINDEX,NOFOLLOW';
      $html_header[ 'css'    ] = array( './css/common.css' );
      $html_header[ 'title'  ] = 'アップグレードFlavor(finish)';

      // アサイン
      $this->smarty->assign ( 'header',    $html_header  );

      $this->smarty->assign ( 'cage',   str_replace( DIRECTORY_SEPARATOR, '.' , $this->obj_sess->sessLoad( 'currentcage' ) ) );

      // 表示
      $this->smarty->display( 'finish.tpl' );

      return true;

    } // end of function:view()

  } // end of class:page06
?>
