<?php
/**
 * アップグレードFlavor画面(1)クラス
 *
 * アップグレードFlavor画面(1)を実現するためのクラス
 *
 * @package   risoluto
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2012 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( 'upgrade_base.inc' );

  class page01 extends upgrade_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * チェック情報格納用変数
     * @access private
     * @var    array
     */
    private $checklist;
    /**
     * チェック結果格納用変数
     * @access private
     * @var    array
     */
    private $checkresult;
    /**
     * エラー発生状況格納用変数
     * @access private
     * @var    boolean
     */
    private $errStatus;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 前画面のCageが現在のCageと同一でない or 前画面のActが「upgrade」 and 「page01」 and 「page02」でない場合、
      // アップグレードFlavorに飛ばす
      $tmp_cage      = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage' ) );
      $tmp_cage_self = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'currentcage' ) );
      $tmp_act       = $this->obj_sess->sessLoad( 'lastact'  );
      if ( $tmp_cage != $tmp_cage_self or  ( $tmp_act != 'upgrade' and  $tmp_act != 'page01' and  $tmp_act != 'page02' ) )
      {
        $this->obj_util->redirectTo( 'upgrade', $tmp_cage_self );
        return false;
      } // end of if

      // チェック対象をセットする
      // 他にチェック対象があれば、この配列に加えてください。
      // path: チェック対象となるパス / stat: あるべき状態（writable: 書込可 / readable: 読込可）
      // readableを指定したとき、その対象が書込可の場合はNGとなります
      clearstatcache();
      $tmp_base = RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' );
      $this->checklist = array(
                                array(
                                       'path' => $tmp_base
                                     , 'stat' => 'writable'
                                     , 'pass' => false
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target
                                     , 'stat' => 'writable'
                                     , 'pass' => true
                                     )
                              , array(
                                       'path' => RISOLUTO_DOCROOT . '/js/' . $this->target . '_ckeditor.js'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/simplepage_ckeditor.js' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_CONF . $this->target . '_version'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/simplepage_version' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_CONF . $this->target . '.ini'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/simplepage.ini' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/menu/00004_' . $this->target . '.tpl'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/00004_simplepage.tpl' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/AUTHORS'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/AUTHORS' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/LICENSE'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/LICENSE' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/pageadd_complete.php'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/pageadd_complete.php' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/pageadd_complete.tpl'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/pageadd_complete.tpl' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/pageadd_confirm.php'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/pageadd_confirm.php' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/pageadd_confirm.tpl'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/pageadd_confirm.tpl' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/pageadd_entry.php'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/pageadd_entry.php' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/pageadd_entry.tpl'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/pageadd_entry.tpl' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/pagedel_complete.php'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/pagedel_complete.php' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/pagedel_complete.tpl'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/pagedel_complete.tpl' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/pagedel_confirm.php'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/pagedel_confirm.php' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/pagedel_confirm.tpl'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/pagedel_confirm.tpl' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/pagelist.php'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/pagelist.php' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/pagelist.tpl'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/pagelist.tpl' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/pagemod_complete.php'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/pagemod_complete.php' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/pagemod_complete.tpl'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/pagemod_complete.tpl' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/pagemod_confirm.php'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/pagemod_confirm.php' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/pagemod_confirm.tpl'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/pagemod_confirm.tpl' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/pagemod_entry.php'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/pagemod_entry.php' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/pagemod_entry.tpl'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/pagemod_entry.tpl' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/pageview.php'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/pageview.php' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/pageview.tpl'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/pageview.tpl' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/simplepage_base.inc'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/simplepage_base.inc' ) ? true : false )
                                     )
                              );

      // チェックメソッドを呼び出し、結果を整形
      foreach( $this->checklist as $dat )
      {
        if ( $dat[ 'pass' ] )
        {
          continue;
        } // end of if

        $tmp_result = $this->obj_util->statChecker( $dat );
        if ( $tmp_result[ 'result' ] == 'NG' )
        {
          $this->errStatus = 'NG';
        } // end of if
        $this->checkresult[] = $tmp_result;
      } // end of foreach

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // ヘッダ情報をセット
      $html_header[ 'robots' ] = 'NOINDEX,NOFOLLOW';
      $html_header[ 'css'    ] = array( './css/common.css' );
      $html_header[ 'title'  ] = 'アップグレードFlavor(1)';

      // アサイン
      $this->smarty->assign ( 'header',    $html_header       );
      $this->smarty->assign ( 'checklist', $this->checkresult );
      $this->smarty->assign ( 'err',       $this->errStatus   );

      $this->smarty->assign ( 'cage',   str_replace( DIRECTORY_SEPARATOR, '.' , $this->obj_sess->sessLoad( 'currentcage' ) ) );

      // 表示
      $this->smarty->display( 'page01.tpl' );

      return true;

    } // end of function:view()

  } // end of class:page01
?>
