<?php
/**
 * ページ情報変更確認画面クラス
 *
 * ページ情報変更確認画面を実現するためのクラス
 *
 * @package   simplepage
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2011 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "simplepage_base.inc" );

  class pagemod_confirm extends simplepage_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_conf;
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 必要なインスタンスを生成
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . $this->mycage . '.ini' );

      // スーパバイザセッション又はアドミンセッションが存在しない場合は、
      // ログイン画面に遷移する
      if ( ! $this->obj_util->is_Admin() )
      {
        $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'login_act'  )
                                   , $this->obj_adminconf->get( 'COMMON', 'login_cage' ) );
        return false;
      } // end of if

      // 前画面のCageが自分と同じでない or 前画面のActが「pagemod_entry」でない場合、
      // 入力画面に飛ばす
      $tmp_cage_last = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage'    ) );
      $tmp_cage_current = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'currentcage' ) );
      $tmp_act = $this->obj_sess->sessLoad( 'lastact' );

      if ( ( $tmp_cage_last != $tmp_cage_current and $tmp_cage_last != 'admin.site' ) or ( $tmp_act != 'pagemod_entry' and $tmp_act != 'uploadviewer' ) )
      {
        $this->obj_util->redirectTo( 'pagelist', $tmp_cage_current );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // 前画面の入力値を取得
      //------------------------------------------------------------------------
      // 初期化
      $tmp_entered[ 'message'    ] = null;
      $tmp_entered[ 'pageid'     ] = null;
      $tmp_entered[ 'slug'       ] = null;
      $tmp_entered[ 'body'       ] = null;
      $tmp_entered[ 'headerinfo' ] = null;

      // ページID
      if ( isset( $_POST[ 'pageid' ] ) )
      {
        $tmp_entered[ 'pageid' ] = strip_tags( trim( $_POST[ 'pageid' ] ) );
      } // end of if
      // 内容
      if ( isset( $_POST[ 'body' ] ) )
      {
        $tmp_entered[ 'body' ] = strip_tags( trim( $_POST[ 'body'  ] ), $this->obj_conf->get( 'ALLOWTAGS', 'body' ) );
      } // end of if
      // スラッグ
      if ( isset( $_POST[ 'slug' ] ) )
      {
        $tmp_entered[ 'slug' ] = strip_tags( trim( $_POST[ 'slug' ] ) );
      } // end of if
      // robot_index
      if ( isset( $_POST[ 'robot_index' ] ) )
      {
        $tmp_entered[ 'headerinfo' ][ 'robot_index' ] = strip_tags( trim( $_POST[ 'robot_index' ] ) );
      } // end of if

      // robot_follow
      if ( isset( $_POST[ 'robot_follow' ] ) )
      {
        $tmp_entered[ 'headerinfo' ][ 'robot_follow' ] = strip_tags( trim( $_POST[ 'robot_follow' ] ) );
      } // end of if

      // title
      if ( isset( $_POST[ 'title' ] ) )
      {
        $tmp_entered[ 'headerinfo' ][ 'title' ] = strip_tags( trim( $_POST[ 'title' ] ) );
      } // end of if

      // description
      if ( isset( $_POST[ 'description' ] ) )
      {
        $tmp_entered[ 'headerinfo' ][ 'description' ] = strip_tags( trim( $_POST[ 'description' ] ) );
      } // end of if

      // keywords
      if ( isset( $_POST[ 'keywords' ] ) )
      {
        $tmp_entered[ 'headerinfo' ][ 'keywords' ] = strip_tags( trim( $_POST[ 'keywords' ] ) );
      } // end of if

      // author
      if ( isset( $_POST[ 'author' ] ) )
      {
        $tmp_entered[ 'headerinfo' ][ 'author' ] = strip_tags( trim( $_POST[ 'author' ] ) );
      } // end of if

      // javascript
      if ( isset( $_POST[ 'javascript' ] ) )
      {
        $tmp_entered[ 'headerinfo' ][ 'javascript' ] = strip_tags( trim( $_POST[ 'javascript' ] ) );
      } // end of if

      // css
      if ( isset( $_POST[ 'css' ] ) )
      {
        $tmp_entered[ 'headerinfo' ][ 'css' ] = strip_tags( trim( $_POST[ 'css' ] ) );
      } // end of if

      // favicon
      if ( isset( $_POST[ 'favicon' ] ) )
      {
        $tmp_entered[ 'headerinfo' ][ 'favicon' ] = strip_tags( trim( $_POST[ 'favicon' ] ) );
      } // end of if



      //------------------------------------------------------------------------
      // 入力情報のチェック
      //------------------------------------------------------------------------
      // ページID
      if ( ! isset( $tmp_entered[ 'pageid' ] ) or !preg_match( '/^[[:digit:]]{1,10}$/', $tmp_entered[ 'pageid' ] ) )
      {
          throw new Exception( 'CANNOT HAPPENED!:Strange pageid' );
          return false;
      } // end of if

      // 内容（入力値が空）
      if ( empty( $tmp_entered[ 'body' ] ) )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'empty_body';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered );
        $this->obj_util->redirectTo( 'pagemod_entry', $tmp_cage_current );
        return false;
      } // end of if

      // スラッグ（フォーマット不正）
      if ( !empty( $tmp_entered[ 'slug' ] ) and !preg_match( '/^[[:alnum:]\.\_\-]{1,255}$/', $tmp_entered[ 'slug' ] ) )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_slug';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered );
        $this->obj_util->redirectTo( 'pagemod_entry', $tmp_cage_current );
        return false;
      } // end of if

      // スラッグ（フォーマット不正）
      if ( !empty( $tmp_entered[ 'slug' ] ) and preg_match( '/^[[:digit:]]{1,10}$/', $tmp_entered[ 'slug' ] ) )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'onlydigit_slug';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered );
        $this->obj_util->redirectTo( 'pagemod_entry', $tmp_cage_current );
        return false;
      } // end of if

      // robots(index)
      if ( $tmp_entered[ 'headerinfo' ][ 'robot_index' ] != 0 and $tmp_entered[ 'headerinfo' ][ 'robot_index' ] != 1 )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_robot_index';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), $tmp_entered );
        $this->obj_util->redirectTo( 'pagemod_entry', $tmp_cage_current );
        return false;
      } // end of if

      // robots(follow)
      if ( $tmp_entered[ 'headerinfo' ][ 'robot_follow' ] != 0 and $tmp_entered[ 'headerinfo' ][ 'robot_follow' ] != 1 )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_robot_follow';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), $tmp_entered );
        $this->obj_util->redirectTo( 'pagemod_entry', $tmp_cage_current );
        return false;
      } // end of if

      // title
      if ( strlen( $tmp_entered[ 'headerinfo' ][ 'title' ] ) > 10000 )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_title';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), $tmp_entered );
        $this->obj_util->redirectTo( 'pagemod_entry', $tmp_cage_current );
        return false;
      } // end of if

      // description
      if ( strlen( $tmp_entered[ 'headerinfo' ][ 'description' ] ) > 10000 )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_description';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), $tmp_entered );
        $this->obj_util->redirectTo( 'pagemod_entry', $tmp_cage_current );
        return false;
      } // end of if

      // keywords
      if ( strlen( $tmp_entered[ 'headerinfo' ][ 'keywords' ] ) > 10000 )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_keywords';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), $tmp_entered );
        $this->obj_util->redirectTo( 'pagemod_entry', $tmp_cage_current );
        return false;
      } // end of if

      // author
      if ( strlen( $tmp_entered[ 'headerinfo' ][ 'author' ] ) > 10000 )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_author';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), $tmp_entered );
        $this->obj_util->redirectTo( 'pagemod_entry', $tmp_cage_current );
        return false;
      } // end of if

      // javascript
      if ( strlen( $tmp_entered[ 'headerinfo' ][ 'javascript' ] ) > 10000 )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_javascript';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), $tmp_entered );
        $this->obj_util->redirectTo( 'pagemod_entry', $tmp_cage_current );
        return false;
      } // end of if

      // css
      if ( strlen( $tmp_entered[ 'headerinfo' ][ 'css' ] ) > 10000 )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_css';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), $tmp_entered );
        $this->obj_util->redirectTo( 'pagemod_entry', $tmp_cage_current );
        return false;
      } // end of if

      // favicon
      if ( strlen( $tmp_entered[ 'headerinfo' ][ 'favicon' ] ) > 10000 )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_favicon';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), $tmp_entered );
        $this->obj_util->redirectTo( 'pagemod_entry', $tmp_cage_current );
        return false;
      } // end of if

      //------------------------------------------------------------------------
      // スラッグ重複チェック
      //------------------------------------------------------------------------
      if ( isset( $tmp_entered[ 'slug' ] ) and !empty( $tmp_entered[ 'slug' ] ) )
      {
        // データベースに接続する
        // データベース操作クラスのインスタンスを生成する
        $this->obj_db = new RisolutoDb();

        // DSN情報取得用にrisoluto.iniをパース
        $tmp_risolutoconf = new RisolutoConf();
        $tmp_risolutoconf->parse( RISOLUTO_CONF . 'risoluto.ini' );

        // データベースに接続する
        if ( $this->obj_db->dbConnect( $tmp_risolutoconf->get( 'DBS', 'DEFAULT_DSN' ) ) )
        {
          // SQL文を組み立てる
          $tmp_t_pages = $this->mycage . '_t_pages';
          $sql =<<<End_Of_SQL

              SELECT count( `pages`.`page_slug` ) as cnt
                FROM $tmp_t_pages pages
               WHERE `pages`.`page_slug` = ?
                 AND `pages`.`page_id`  <> ?

End_Of_SQL;

          // パラメタも用意する
          $param = array(
                          $tmp_entered[ 'slug' ]
                        , $tmp_entered[ 'pageid' ]
                        );

          // SQLの実行に失敗した場合は、例外を投げる
          $tmp_result = $this->obj_db->dbGetRow( $sql, $param );
          if ( PEAR::isError( $tmp_result ) )
          {
            // 接続をクローズする
            $this->obj_db->dbDisConnect();
            throw new Exception( 'count slug Get Failure' );
            return false;
          } // end of if
          // 入力された値と、取得した値を使ってデータをインサートする
          else
          if ( $tmp_result[ 'cnt' ] > 0 )
          {
            // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
            $tmp_entered[ 'message' ] = 'slug_conflict';
            $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered );
            $this->obj_util->redirectTo( 'pagemod_entry', $tmp_cage_current );
            return false;
          } // end of elseif

        } // end of if
        // データベースに接続できなかった場合は、例外を投げる
        else
        {
          throw new Exception( 'DB Connection Failure' );
          return false;
        } // end of else

      } // end of if



      //------------------------------------------------------------------------
      // 特に問題がなければ、画面表示用にクラス変数とセッションに値をセットする
      //------------------------------------------------------------------------
      $this->gotDat = $tmp_entered;
      $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered );

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // アサイン
      $this->smarty->assign ( 'header',             $this->obj_util->getHeader() );

      $this->smarty->assign ( 'entered_body',       stripslashes( $this->gotDat[ 'body' ] ) );
      $this->smarty->assign ( 'entered_slug',       $this->gotDat[ 'slug' ] );
      $this->smarty->assign ( 'entered_headerinfo', $this->gotDat[ 'headerinfo' ] );

      $this->smarty->assign ( 'mycage',             $this->mycage );

      // 表示
      $this->smarty->display( 'pagemod_confirm.tpl' );

      return true;

    } // end of function:view()

  } // end of class:pagemod_confirm

?>
