<?php
/**
 * ページ情報画面クラス
 *
 * ページ情報画面を実現するためのクラス
 *
 * @package   simplepage
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2011 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "simplepage_base.inc" );
  /**
   * データベース操作クラス
   */
  require_once( RISOLUTO_FUNC . 'risoluto_db.php' );

  class pageview extends simplepage_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * データベース操作クラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_db;
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_conf;
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 必要なインスタンスを生成
      $this->obj_db   = new RisolutoDb();
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . 'risoluto.ini' );



      //------------------------------------------------------------------------
      // GETでページIDがセットされていたら、取得する
      //------------------------------------------------------------------------
      // ページID
      if ( isset( $_GET[ 'id' ] ) and !empty( $_GET[ 'id' ] ) )
      {
        $tmp_entered[ 'id' ] = strip_tags( trim( $_GET[ 'id' ] ) );
      } // end of if
      else
      {
        $tmp_entered[ 'id' ] = 0;
      } // end of else



      //------------------------------------------------------------------------
      // 入力情報のチェック
      //------------------------------------------------------------------------
      // 渡されてきたページIDが数字1～10桁でなければ、スラッグして取り扱う
      if ( ! preg_match( '/^[[:digit:]]{1,10}$/', $tmp_entered[ 'id' ] ) )
      {
        $tmp_target = '`pages`.`page_slug`';
      } // end of if
      else
      {
        $tmp_target = '`pages`.`page_id`';
      } // end of else



      //------------------------------------------------------------------------
      // DBから情報を取得する
      //------------------------------------------------------------------------

      // データベースに接続する
      if ( $this->obj_db->dbConnect( $this->obj_conf->get( 'DBS', 'DEFAULT_DSN' ) ) )
      {
        // SQL文を組み立てる
        $tmp_t_pages = $this->mycage . '_t_pages';
        $sql =<<<End_Of_SQL

              SELECT `pages`.`page_id`    -- ID
                   , `pages`.`page_body`  -- 内容
                   , `pages`.`page_slug`  -- スラッグ
                FROM $tmp_t_pages pages
               WHERE $tmp_target = ?

End_Of_SQL;

        // パラメタも用意する
        $param = array(
                        $tmp_entered[ 'id' ]
                      );

        // SQLを実行
        $tmp_result = $this->obj_db->dbGetRow( $sql, $param );
        if ( PEAR::isError( $tmp_result ) )
        {
          // エラーの場合は値を取得できなかったものとして扱う
          $tmp_result = null;
        } // end of if
        else
        {
          // 正常に実行できた場合は取得した値を採用する
          $this->gotDat = $tmp_result;
        } // end of else



        // ヘッダ情報を取得
        // SQL文を組み立てる
        $tmp_cage = '_' . $this->mycage . '_SYSTEM_';
        $sql =<<<End_Of_SQL

              SELECT `headers`.`robot_index`  -- robots(index)
                   , `headers`.`robot_follow` -- robots(follow)
                   , `headers`.`title`        -- title
                   , `headers`.`description`  -- description
                   , `headers`.`keywords`     -- keywords
                   , `headers`.`author`       -- author
                   , `headers`.`javascript`   -- JavaScriptファイルパス
                   , `headers`.`css`          -- CSSファイルパス
                   , `headers`.`favicon`      -- Faviconファイルパス
                FROM `risoluto_t_headerinfo` headers
               WHERE `headers`.`act`  = ?
                 AND `headers`.`cage` = ?

End_Of_SQL;

        // パラメタも用意する
        $param = array(
                        $this->gotDat[ 'page_id' ]
                      , $tmp_cage
                      );

        // SQLを実行
        $tmp_result = $this->obj_db->dbGetRow( $sql, $param );
        if ( PEAR::isError( $tmp_result ) or empty( $tmp_result ) )
        {
          // エラーの場合は標準のヘッダを取得する
          $this->gotDat[ 'headerinfo' ] = $this->obj_util->getHeader();
        } // end of if
        else
        {

          // 正常に実行できた場合は取得した値を採用する
          // robots(index)
          if( $tmp_result[ 'robot_index' ] == 0 )
          {
            $tmp_val[ 'robots' ] = 'noindex,';
          } // end of if
          else
          {
            $tmp_val[ 'robots' ] = 'index,';
          } // end of else

          // robots(follow)
          if( $tmp_result[ 'robot_follow' ] == 0 )
          {
            $tmp_val[ 'robots' ] .= 'nofollow';
          } // end of if
          else
          {
            $tmp_val[ 'robots' ] .= 'follow';
          } // end of else

          // title
          $tmp_val[ 'title'       ] = $tmp_result[ 'title'       ];
          // description
          $tmp_val[ 'description' ] = $tmp_result[ 'description' ];
          // keywords
          $tmp_val[ 'keywords'    ] = $tmp_result[ 'keywords'    ];
          // author
          $tmp_val[ 'author'      ] = $tmp_result[ 'author'      ];

          // JavaScript
          $tmp_val[ 'javascript' ] = explode( ',', $tmp_result[ 'javascript' ] );
          // CSS
          $tmp_val[ 'css'        ] = explode( ',', $tmp_result[ 'css'        ] );

          // URL情報等を付け加える
          $tmp_val[ 'normal_url' ] = $this->obj_util->getBaseUrl();
          $tmp_val[ 'https_url'  ] = str_replace( 'http://',   'https://', $tmp_val[ 'normal_url' ] );
          $tmp_val[ 'http_url'   ] = str_replace( 'https://',  'http://',  $tmp_val[ 'normal_url' ] );

          $this->gotDat[ 'headerinfo' ] = $tmp_val;
        } // end of else

      } // end of if
      // データベースに接続できなかった場合は値を取得できなかったものとして扱う
      else
      {
        $this->gotDat = null;
      } // end of else



      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {

      // アサイン
      $this->smarty->assign ( 'header', $this->gotDat[ 'headerinfo' ] );
      $this->smarty->assign ( 'body',   stripslashes( $this->gotDat[ 'page_body' ] ) );

      // 表示
      $this->smarty->display( 'pageview.tpl' );

      return true;

    } // end of function:view()

  } // end of class:pageview
?>
