/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import java.io.PrintStream;

/**
 * DMI
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class Dmi extends IndexObject {

	/**
	 * VAo[WID
	 *  
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * +DI
	 * 
	 * @since 1.00
	 */
	private final double m_plusDi;
	
	/**
	 * -DI
	 * 
	 * @since 1.00
	 */
	private final double m_minusDi;

	/**
	 * Dmi𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_tag ^O
	 * @param p_plusDi +DI
	 * @param p_minusDi -DI
	 */
	public Dmi(Tag p_tag, double p_plusDi, double p_minusDi) {
		super(p_tag);
		m_plusDi = p_plusDi;
		m_minusDi = p_minusDi;
	}
	
	/**
	 * DXԂ܂B
	 * 
	 * @since 1.00
	 * @return DX
	 */
	public double getDx() {
		if (m_plusDi + m_minusDi == 0) return 0;
		/*
               (+DI) - (-DIjiΒlj
          DX = ------------------------ * 100
                   i+DIj+i-DIj
	 @@*/
		double returnValue = Math.abs(m_plusDi - m_minusDi) / 
				(m_plusDi + m_minusDi) * 100;
		return returnValue;
	}

	/**
	 * +DIԂ܂B
	 * 
	 * @since 1.00
	 * @return +DI
	 */
	public double getPlusDi() {
		return m_plusDi;
	}

	/**
	 * -DIԂ܂B
	 * 
	 * @since 1.00
	 * @return -DI
	 */
	public double getMinusDi() {
		return m_minusDi;
	}

	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexObject#printHeader(java.io.PrintStream)
	 */
	@Override
	public void printHeader(PrintStream p_out) {
		p_out.println("Tag,'+DI','-DI',DX");
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexObject#print(java.io.PrintStream)
	 */
	@Override
	public void print(PrintStream p_out) {
		p_out.println("'" + getTag().getString() + "'," + getPlusDi() + "," + 
				getMinusDi() + "," + getDx());
	}
	
}
