/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.html;

import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;

/**
 * formɊ܂܂Ă邷ׂĂselect^ÕXg
 *
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class HtmlSelectList implements Serializable {

	/**
	 * VAo[Whc
	 * 
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * select^ÕXg
	 * 
	 * @since 1.00
	 */
	private ArrayList<HtmlSelect> m_htmlSelectList;
	
	/**
	 * HtmlSelectList𐶐܂B
	 * 
	 * @since 1.00
	 */
	public HtmlSelectList() {
		m_htmlSelectList = new ArrayList<HtmlSelect>();
	}
	
	/**
	 * select^OXgɒǉ܂B
	 * 
	 * @since 1.00
	 * @param p_htmlSelect ǉselect^O
	 */
	protected void add(HtmlSelect p_htmlSelect) {
		m_htmlSelectList.add(p_htmlSelect);
	}
	
	/**
	 * w肳ꂽnameɃ}b`select^OԂ܂B
	 * 
	 * @since 1.00
	 * @param p_name name
	 * @return select^O
	 * @throws HtmlFormException w肳ꂽnameɃ}b`select^O݂Ȃꍇ
	 */
	public HtmlSelect getHtmlSelectByName(String p_name) throws HtmlFormException {
		for (int i=0;i<m_htmlSelectList.size();i++) {
			HtmlSelect htmlSelect = m_htmlSelectList.get(i);
			if (htmlSelect.getName().equals(p_name)) {
				return htmlSelect;
			}
		}
		throw new HtmlFormException("method:HtmlSelectList.getHtmlSelectByName p_name=" + p_name);
	}
	
	/**
	 * ׂĂselect^O̓ew肵o̓Xg[ɏo͂܂B
	 * 
	 * @since 1.00
	 * @param p_out o̓Xg[
	 */
	public void print(PrintStream p_out) {
		for (int i=0; i<m_htmlSelectList.size(); i++) {
			HtmlSelect htmlSelect = m_htmlSelectList.get(i);
			p_out.println("-- HtmlSelect("+i+") --");
			p_out.println(htmlSelect.getId()+"\t"+htmlSelect.getName());
			p_out.println("id\tvalue\ttitle\tselected");
			htmlSelect.print(p_out);
		}
	}

	/**
	 * ׂĂselect^ONG𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_charset GR[hۂ̕Zbgw肵܂B
	 * @see <a href=
	 * "http://sdc.sun.co.jp/java/docs/j2se/1.4/ja/docs/ja/guide/intl/encoding.doc.html">
	 * Zbg</a>
	 * @return NG
	 * @throws HtmlFormException select^ÕACeIĂȂꍇ
	 * @throws UnsupportedEncodingException NG̃GR[hɎsꍇ
	 */
	public String createQueryString(String p_charset) throws HtmlFormException, UnsupportedEncodingException {
		String returnValue = "";
		for (int i=0; i<m_htmlSelectList.size(); i++) {
			HtmlSelect htmlSelect = m_htmlSelectList.get(i);
			String name = htmlSelect.getName();
			if (htmlSelect.getHtmlOptionList().getSelectedItem()==null)
				throw new HtmlFormException("Not Select Item: " + name);
			String selectedItem = htmlSelect.getHtmlOptionList().getSelectedItem().getValue();
			returnValue += "&" + name + "=" + URLEncoder.encode(selectedItem, p_charset);
		}
		return returnValue;
	}

	/**
	 * w肳ꂽselect^OXgƌ`mF܂B
	 * 
	 * @since 1.00
	 * @param p_other select^OXg
	 * @return w肳ꂽselect^OXgƌ`ꍇtrueԂ܂B
	 */
	public boolean equalsFormat(HtmlSelectList p_other) {
		if (m_htmlSelectList.size()!=p_other.m_htmlSelectList.size()) 
			return false; 
		for (int i=0;i<m_htmlSelectList.size();i++) {
			HtmlSelect me = m_htmlSelectList.get(i);
			HtmlSelect other = p_other.m_htmlSelectList.get(i);
			if (!me.equalsFormat(other)) return false;
		}
		return true;	
	}
	
}
