/**
 * Copyright (C) 2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;

/**
 * JEg_EVOio̓ubN<br>
 * ̓VOi""""ɂȂɃJEg_EJn
 * JEg_EIAftHgVOio͂܂B
 * 
 * @since 2.10
 * @author Copyright (C) 2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@TypeSignalBlock
@EnabledDefaultSignal
@GeneDefaultLabelList(values={"count"})
@InputComponentList(values={"@Signal"})
public class CountDownSignalBlock extends SignalBlock {

	/**
	 * JEgB̓f[^̐ŎwB
	 * 
	 * @since 2.10
	 */
	private final int m_initialCount;

	/**
	 * JEg
	 * 
	 * @since 2.10
	 */
	private int m_currentCount;

	/**
	 * OJEg_Ẽ^O
	 * 
	 * @since 2.10
	 */
	private Tag m_prevTag;
	
	/**
	 * CountDownSignalBlock𐶐܂B
	 * 
	 * @since 2.10
	 * @param p_label x
	 * @param p_priority Dx
	 * @param p_geneList p[^Xg
	 * @param p_countLabel JEg̃p[^x
	 * @throws GeneListException ݂Ȃp[^xw肵ꍇ
	 */
	public CountDownSignalBlock(String p_label, int p_priority, GeneList p_geneList,
			String p_countLabel) throws GeneListException {
		super(p_label, p_priority);
		m_initialCount = p_geneList.getGene(p_countLabel).getIntValue();
	}

	/* ( Javadoc)
	 * @see jp.robotbrain.signal.SignalBlock#getJudgmentResult()
	 */
	@Override
	public JudgmentResult getJudgmentResult() throws IndexStreamException {
		Tag inputTag = getInputTag();
		if (inputTag==null) return new JudgmentResult(null,NmSignal.NOSIGNAL);
		JudgmentResult returnValue = new JudgmentResult(inputTag,NmSignal.NOSIGNAL);
		if (!inputTag.equals(m_prevTag)) {
			if (m_currentCount>0) {
				// JEg_EJnĂ
				--m_currentCount;
				if (m_currentCount<=0) {
					m_currentCount = 0;
					returnValue = new JudgmentResult(inputTag, getDefaultSignal());
				}
			} else {
				JudgmentResult inputSignal = super.getJudgmentResult();
				// JEg_EJnĂȂ
				if (inputSignal.getSignal()==NmSignal.LONG || inputSignal.getSignal()==NmSignal.SHORT) {
					// VOioJEg_EJn
					m_currentCount = m_initialCount;
				}
			}
		}
		m_prevTag = inputTag.clone();
		setDetails("[" + getLabel() + "]" + returnValue.getSignal().toString() + "(count=" + m_currentCount + ")");
		return returnValue;
	}
	
}
