/**
 * Copyright (C) 2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

/**
 * baseLineߕӂmoveLineɃftHgVOio͂܂B
 * baseLineߕӂ͈̔͂́AオbaseLine{upperRangeBbaseLine-lowerRangełB
 * Ⴆ΁uߋ̍lɋ߂ÂɃVOi𔭐vƂ悤Ȏg܂B
 * 
 * @since 2.04
 * @author Copyright (C) 2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@TypeSignalStream
@EnabledDefaultSignal
@InputComponentList(values={"baseLine@IndexLine", "*upperRange@IndexLine", "*lowerRange@IndexLine", "moveLine@IndexLine"})
public class InnerRangeDefaultSignal extends SignalStream {

	/**
	 * InnerRangeDefaultSignal𐶐܂B
	 * 
	 * @since 2.04
	 * @param p_label x
	 * @param p_priority Dx
	 */
	public InnerRangeDefaultSignal(String p_label, int p_priority) {
		super(p_label, p_priority);
		getPortList().add("baseLine@IndexLine");
		getPortList().add("*upperRange@IndexLine");
		getPortList().add("*lowerRange@IndexLine");
		getPortList().add("moveLine@IndexLine");
	}

	/* ( Javadoc)
	 * @see jp.robotbrain.signal.Signal#getJudgmentResult()
	 */
	@Override
	public JudgmentResult getJudgmentResult() throws IndexStreamException {
		IndexStreamPort base = getPortList().get("baseLine@IndexLine");
		IndexStreamPort upper = getPortList().get("*upperRange@IndexLine");
		IndexStreamPort lower = getPortList().get("*lowerRange@IndexLine");
		IndexStreamPort move = getPortList().get("moveLine@IndexLine");
		// portnull`FbN
		if (base==null)
			throw new IndexStreamException("baseLine@IndexLine Port Null Error");
		if (upper==null)
			throw new IndexStreamException("*upperRange@IndexLine Port Null Error");
		if (lower==null)
			throw new IndexStreamException("*lowerRange@IndexLine Port Null Error");
		if (move==null)
			throw new IndexStreamException("moveLine@IndexLine Port Null Error");
		// Xgnull`FbN
		if (base.getObjectList()==null) return new JudgmentResult(null,NmSignal.NOSIGNAL);
		if (move.getObjectList()==null) return new JudgmentResult(null,NmSignal.NOSIGNAL);
		// CX^X`FbN
		if (!(base.getObjectList() instanceof IndexLine))
			throw new IndexStreamException("baseLine@IndexLine Instance Error");
		if (!(move.getObjectList() instanceof IndexLine))
			throw new IndexStreamException("moveLine@IndexLine Instance Error");
		// TCY`FbN
		IndexLine baseLine = (IndexLine)base.getObjectList();
		if (baseLine.size()<1) {
			setDetails(NmSignal.NOSIGNAL.toString());
			return new JudgmentResult(null,NmSignal.NOSIGNAL);
		}
		IndexLine moveLine = (IndexLine)move.getObjectList();
		if (moveLine.size()<1) {
			setDetails(NmSignal.NOSIGNAL.toString());
			return new JudgmentResult(null,NmSignal.NOSIGNAL);
		}
		// σ|[g`FbN
		IndexLine upperLine = null;
		if (upper.getObjectList()!=null) {
			// CX^X`FbN
			if (!(upper.getObjectList() instanceof IndexLine))
				throw new IndexStreamException("*upperRange@IndexLine Instance Error");
			// TCY`FbN
			upperLine = (IndexLine)upper.getObjectList();
			if (upperLine.size()<1) {
				setDetails(NmSignal.NOSIGNAL.toString());
				return new JudgmentResult(null,NmSignal.NOSIGNAL);
			}
		}
		IndexLine lowerLine = null;
		if (lower.getObjectList()!=null) {
			// CX^X`FbN
			if (!(lower.getObjectList() instanceof IndexLine))
				throw new IndexStreamException("*lowerRange@IndexLine Instance Error");
			// TCY`FbN
			lowerLine = (IndexLine)lower.getObjectList();
			if (lowerLine.size()<1) {
				setDetails(NmSignal.NOSIGNAL.toString());
				return new JudgmentResult(null,NmSignal.NOSIGNAL);
			}
		}
		// VOi
		NmSignal returnValue = NmSignal.NOSIGNAL;
		double baseValue = baseLine.getLast().getValue();
		double upperValue = 0;
		if (upperLine!=null) {
			upperValue = upperLine.getLast().getValue();
		}
		double lowerValue = 0;
		if (lowerLine!=null) {
			lowerValue = lowerLine.getLast().getValue();
		}
		double moveValue = moveLine.getLast().getValue();
		if (moveValue<=baseValue+upperValue && moveValue>=baseValue-lowerValue) {
			// ͈͓
			returnValue = getDefaultSignal();
		} else {
			// ͈͊O
			returnValue = NmSignal.NOSIGNAL;
		}
		setDetails("[" + getLabel() + "]" + returnValue.toString());
		return new JudgmentResult(moveLine.getLast().getTag(),returnValue);
	}

}
