/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.framework;

import java.io.Serializable;

import jp.robotbrain.common.DoubleEx;
import jp.robotbrain.common.UtilCalc;

/**
 * p[^
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public final class Gene implements Cloneable, Serializable {

	/**
	 * VAo[Whc
	 * 
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * x
	 * 
	 * @since 1.00
	 */
	private String m_label;
	
	/**
	 * l̉
	 * 
	 * @since 1.00
	 */
	private double m_min;

	/**
	 * l̏
	 * 
	 * @since 1.00
	 */
	private double m_max;
	
	/**
	 * œK̕ϓ
	 * 
	 * @since 1.00
	 */
	private double m_step;
	
	/**
	 * l
	 * 
	 * @since 1.00
	 */
	private double m_value;

	/**
	 * _ȉ̌
	 * 
	 * @since 1.00
	 */
	private int m_scale;

	/**
	 * œKΏۃtO
	 * 
	 * @since 1.00
	 */
	private boolean m_optimize;
	
	/**
	 * Gene𐶐܂B
	 * 
	 * @since 1.00
	 */
	public Gene() {
	}
	
	/**
	 * l_ɏ܂B
	 * 
	 * @since 1.00
	 */
	public void initRandom() {
		int valueCount = (int)((getMax() - getMin()) / getStep());
		setDoubleValue(getMin() + getStep() * UtilCalc.random(valueCount));
	}

	/**
	 * w肳ꂽIuWFNgƓꂩԂ܂B
	 * 
	 * @since 1.00
	 * @param p_other rΏۂ̃IuWFNg
	 * @return w肳ꂽIuWFNgƓłtrueԂ
	 */
	@Override
	public boolean equals(Object p_other) {
		if (p_other==null) return false;
		if (getLabel()==null) return false;
		if (p_other instanceof Gene) {
			Gene other = (Gene)p_other;
			return getLabel().equals(other.getLabel());
		} else {
			return false;
		}
	}
	
	/**
	 * nbVR[hԂ܂B
	 * 
	 * @since 1.00
	 * @return nbVR[h
	 */
	@Override
	public int hashCode() {
		return getLabel().hashCode();
	}
	
	/**
	 * N[𐶐Ԃ܂B
	 * 
	 * @since 1.00
	 * @return N[
	 */
	@Override
	public Gene clone() {
		Gene destg = new Gene();
		destg.setLabel(getLabel());
		destg.setDoubleValue(getDoubleValue());
		destg.setMax(getMax());
		destg.setMin(getMin());
		destg.setStep(getStep());
		destg.setScale(getScale());
		destg.setOptimize(isOptimize());
		return destg;
	}
	
	/**
	 * p[^̃fUCRs[܂B
	 * 
	 * @since 1.00
	 * @param p_src Rs[
	 */
	protected void copyDesign(Gene p_src) {
		setMax(p_src.getMax());
		setMin(p_src.getMin());
		setStep(p_src.getStep());
		setScale(p_src.getScale());
		setOptimize(p_src.isOptimize());
	}
	
	/**
	 * ݒ󋵂𕶎ŕԂ܂B
	 * 
	 * @since 1.00
	 * @return ݂̐ݒ
	 */
	public String getStatus() {
		String returnValue = getLabel();
		returnValue += ",optimize=" + isOptimize();
		for (double j=getMin();DoubleEx.round(j, getScale())<=getMax();
			j=DoubleEx.round(j+getStep(), getScale())) {
			returnValue += ",";
			double listvalue = DoubleEx.round(j, getScale());
			if (listvalue==getDoubleValue()) {
				returnValue += "(";
			}
			returnValue += DoubleEx.format(listvalue, getScale());
			if (listvalue==getDoubleValue()) {
				returnValue += ")";
			}
		}
		return returnValue;
	}
	
	/**
	 * xݒ肵܂B
	 * 
	 * @since 1.00
	 * @param p_label x
	 */
	public void setLabel(String p_label) {
		m_label = p_label;
	}

	/**
	 * xԂ܂B
	 * 
	 * @since 1.00
	 * @return x
	 */
	public String getLabel() {
		return m_label;
	}

	/**
	 * l̏ݒ肵܂B
	 * 
	 * @since 1.00
	 * @param p_max l̏
	 */
	public void setMax(double p_max) {
		m_max = p_max;
	}

	/**
	 * l̏Ԃ܂B
	 * 
	 * @since 1.00
	 * @return l̏
	 */
	public double getMax() {
		return DoubleEx.round(m_max, m_scale);
	}

	/**
	 * l̉ݒ肵܂B
	 * 
	 * @since 1.00
	 * @param p_min l̉
	 */
	public void setMin(double p_min) {
		m_min = p_min;
	}

	/**
	 * l̉Ԃ܂B
	 * 
	 * @since 1.00
	 * @return l̉
	 */
	public double getMin() {
		return DoubleEx.round(m_min, m_scale);
	}

	/**
	 * lݒ肵܂B
	 * 
	 * @since 1.00
	 * @param p_value l
	 */
	public void setDoubleValue(double p_value) {
		m_value = p_value;
	}

	/**
	 * lԂ܂B
	 * 
	 * @since 1.00
	 * @return l
	 */
	public double getDoubleValue() {
		return DoubleEx.round(m_value, m_scale);
	}

	/**
	 * lԂ܂B
	 * 
	 * @since 1.00
	 * @return l
	 */
	public int getIntValue() {
		return (int)m_value;
	}
	
	/**
	 * œK̕ϓݒ肵܂B
	 * 
	 * @since 1.00
	 * @param p_step œK̕ϓ
	 */
	public void setStep(double p_step) {
		m_step = p_step;
	}

	/**
	 * œK̕ϓԂ܂B
	 * 
	 * @since 1.00
	 * @return œK̕ϓ
	 */
	public double getStep() {
		return DoubleEx.round(m_step, m_scale);
	}

	/**
	 * _ȉ̌ݒ肵܂B
	 * 
	 * @since 1.00
	 * @param p_scale _ȉ̌
	 */
	public void setScale(int p_scale) {
		m_scale = p_scale;
	}

	/**
	 * _ȉ̌Ԃ܂B
	 * 
	 * @since 1.00
	 * @return _ȉ̌
	 */
	public int getScale() {
		return m_scale;
	}

	/**
	 * œKΏۃtOݒ肵܂B
	 * 
	 * @since 1.00
	 * @param p_optimize œKł̃p[^œKꍇtrueݒ肵܂B
	 */
	public void setOptimize(boolean p_optimize) {
		m_optimize = p_optimize;
	}

	/**
	 * œKΏۃtOԂ܂B
	 * 
	 * @since 1.00
	 * @return œKł̃p[^œKꍇtrueԂ܂B
	 */
	public boolean isOptimize() {
		return m_optimize;
	}
	
}
