/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.html;

import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;

/**
 * formɊ܂܂Ă邷ׂĂinput^O(button^O܂)̃Xg
 *
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class HtmlInputList implements Serializable {
	
	/**
	 * VAo[Whc
	 * 
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * input^ÕXg
	 * 
	 * @since 1.00
	 */
	private ArrayList<HtmlInput> m_htmlInputList;
	
	/**
	 * HtmlInputList𐶐܂B
	 * 
	 * @since 1.00
	 */
	public HtmlInputList() {
		m_htmlInputList = new ArrayList<HtmlInput>();
	}
	
	/**
	 * input^OXgɒǉ܂B܂^OXgɂꍇ͒ǉ܂B
	 * 
	 * @since 1.00
	 * @param p_htmlInput ǉinput^O
	 */
	protected void add(HtmlInput p_htmlInput) {
		if (m_htmlInputList.indexOf(p_htmlInput)==-1) m_htmlInputList.add(p_htmlInput);
	}

	/**
	 * w肳ꂽnameɃ}b`input^O݂ꍇtrueԂ܂B
	 * 
	 * @since 1.00
	 * @param p_name name
	 * @return input^O̗L
	 */
	public boolean isExistHtmlInputByName(String p_name) {
		if (m_htmlInputList.size()<=0) {
			return false;
		}
		for (int i=0;i<m_htmlInputList.size();i++) {
			HtmlInput htmlInput = m_htmlInputList.get(i);
			if (htmlInput.getName().equals(p_name)) {
				return true;
			}
		}
		return false;
	}	
	
	/**
	 * w肳ꂽnameɃ}b`input^OԂ܂B
	 * radiȍꍇ̓`FbNĂ̂Ԃ܂B
	 * 
	 * @since 1.00
	 * @param p_name name
	 * @return input^O
	 * @throws HtmlFormException w肳ꂽnameɃ}b`input^O݂Ȃꍇ
	 */
	public HtmlInput getHtmlInputByName(String p_name) throws HtmlFormException {
		if (m_htmlInputList.size()<=0) {
			throw new HtmlFormException("method:HtmlInputList.getHtmlInputByName size=0");
		}
		for (int i=0;i<m_htmlInputList.size();i++) {
			HtmlInput htmlInput = m_htmlInputList.get(i);
			if (htmlInput.getName().equals(p_name)) {
				if (htmlInput.getType().equals("radio")) {
					if (htmlInput.isSelected()) {
						return htmlInput;
					}
				} else {	
					return htmlInput;
				}	
			}
		}
		throw new HtmlFormException("method:HtmlInputList.getHtmlInputByName p_name=" + p_name);
	}	

	/**
	 * w肳ꂽidɃ}b`input^OԂ܂B
	 * 
	 * @since 1.00
	 * @param p_id id
	 * @return input^O
	 * @throws HtmlFormException w肳ꂽidɃ}b`input^O݂Ȃꍇ
	 */
	public HtmlInput getHtmlInputById(String p_id) throws HtmlFormException {
		if (m_htmlInputList.size()<=0) {
			throw new HtmlFormException("method:HtmlInputList.getHtmlInputById size=0");
		}
		for (int i=0;i<m_htmlInputList.size();i++) {
			HtmlInput htmlInput = m_htmlInputList.get(i);
			if (htmlInput.getId().equals(p_id)) {
				return htmlInput;
			}
		}
		throw new HtmlFormException("method:HtmlInputList.getHtmlInputById p_id=" + p_id);
	}	
	
	/**
	 * w肳ꂽvaluesubmit{^NbN܂B
	 * if[^ANbNԂɂ܂j
	 * 
	 * @since 1.00
	 * @param p_value value
	 * @throws HtmlFormException w肳ꂽvalueɃ}b`submit{^݂Ȃꍇ
	 */
	public void clickSubmitByValue(String p_value) throws HtmlFormException {
		if (m_htmlInputList.size()<=0) {
			throw new HtmlFormException("method:HtmlInputList.clickSubmitByValue size=0");
		}
		int count = 0;
		HtmlInput select = null;
		for (int i=0;i<m_htmlInputList.size();i++) {
			HtmlInput htmlInput = m_htmlInputList.get(i);
			if (htmlInput.getType().equals("submit") && htmlInput.getValue().equals(p_value)) {
				select = htmlInput;
				++count;
			}
		}
		if (count<1) {
			throw new HtmlFormException("method:HtmlInputList.clickSubmitByValue" +
					" p_value=" + p_value + " count=" + count);
		}
		select.setSelected(true);
	}	

	/**
	 * w肳ꂽnamesubmit{^NbN܂B
	 * if[^ANbNԂɂ܂j
	 * 
	 * @since 1.00
	 * @param p_name name
	 * @throws HtmlFormException w肳ꂽnameɃ}b`submit{^݂Ȃꍇ
	 */
	public void clickSubmitByName(String p_name) throws HtmlFormException {
		if (m_htmlInputList.size()<=0) {
			throw new HtmlFormException("method:HtmlInputList.clickSubmitByName size=0");
		}
		int count = 0;
		HtmlInput select = null;
		for (int i=0;i<m_htmlInputList.size();i++) {
			HtmlInput htmlInput = m_htmlInputList.get(i);
			if (htmlInput.getType().equals("submit") && htmlInput.getName().equals(p_name)) {
				select = htmlInput;
				++count;
			}
		}
		if (count<1) {
			throw new HtmlFormException("method:HtmlInputList.clickSubmitByName" +
					" p_name=" + p_name + " count=" + count);
		}
		select.setSelected(true);
	}	

	/**
	 * w肳ꂽnamevalueradio{^NbN܂B
	 * if[^ANbNԂɂ܂j
	 * 
	 * @since 1.00
	 * @param p_name radioname
	 * @param p_value value
	 * @throws HtmlFormException w肳ꂽnamevalueɃ}b`radio
	 * ݂ȂÂꍇ
	 */
	public void clickRadioByNameAndValue(String p_name, String p_value) 
		throws HtmlFormException {
		if (m_htmlInputList.size()<=0) {
			throw new HtmlFormException("method:HtmlInputList.clickRadioByNameAndValue size=0");
		}
		int count = 0;
		HtmlInput select = null;
		for (int i=0;i<m_htmlInputList.size();i++) {
			HtmlInput htmlInput = m_htmlInputList.get(i);
			if (htmlInput.getType().equals("radio") && 
				htmlInput.getValue().equals(p_value) &&
				htmlInput.getName().equals(p_name)) {
				select = htmlInput;
				++count;
			}
		}
		// ݂ȂdĂꍇNGԂ
		if (count!=1) {
			throw new HtmlFormException("method:HtmlInputList.clickRadioByNameAndValue" +
					" p_name=" + p_name + " p_value=" + p_value + " count=" + count);
		}
		select.setSelected(true);
	}	

	/**
	 * w肳ꂽnameidradio{^NbN܂B
	 * if[^ANbNԂɂ܂j
	 * 
	 * @since 1.12
	 * @param p_name radioname
	 * @param p_id id
	 * @throws HtmlFormException w肳ꂽnameidɃ}b`radio
	 * ݂ȂÂꍇ
	 */
	public void clickRadioByNameAndId(String p_name, String p_id) 
		throws HtmlFormException {
		if (m_htmlInputList.size()<=0) {
			throw new HtmlFormException("method:HtmlInputList.clickRadioByNameAndId size=0");
		}
		int count = 0;
		HtmlInput select = null;
		for (int i=0;i<m_htmlInputList.size();i++) {
			HtmlInput htmlInput = m_htmlInputList.get(i);
			if (htmlInput.getType().equals("radio") && 
				htmlInput.getId().equals(p_id) &&
				htmlInput.getName().equals(p_name)) {
				select = htmlInput;
				++count;
			}
		}
		// ݂ȂdĂꍇNGԂ
		if (count!=1) {
			throw new HtmlFormException("method:HtmlInputList.clickRadioByNameAndId" +
					" p_name=" + p_name + " p_id=" + p_id + " count=" + count);
		}
		select.setSelected(true);
	}	

	/**
	 * w肳ꂽnameɊYԍŏradio{^NbN܂B
	 * if[^ANbNԂɂ܂j
	 * 
	 * @since 1.20
	 * @param p_name radioname
	 * @throws HtmlFormException w肳ꂽnameɃ}b`radio{^݂Ȃꍇ
	 */
	public void clickFirstRadioByName(String p_name) 
		throws HtmlFormException {
		if (m_htmlInputList.size()<=0) {
			throw new HtmlFormException("method:HtmlInputList.clickFirstRadioByName size=0");
		}
		int count = 0;
		HtmlInput select = null;
		for (int i=0;i<m_htmlInputList.size();i++) {
			HtmlInput htmlInput = m_htmlInputList.get(i);
			if (htmlInput.getType().equals("radio") && 
				htmlInput.getName().equals(p_name)) {
				select = htmlInput;
				++count;
				break;
			}
		}
		// ݂ȂꍇNGԂ
		if (count!=1) {
			throw new HtmlFormException("method:HtmlInputList.clickFirstRadioByName" +
					" p_name=" + p_name + " count=" + count);
		}
		select.setSelected(true);
	}	
	
	/**
	 * ׂĂinput^O̓ew肵o̓Xg[ɏo͂܂B
	 * 
	 * @since 1.00
	 * @param p_out o̓Xg[
	 */
	public void print(PrintStream p_out) {
		for (int i=0; i<m_htmlInputList.size(); i++) {
			HtmlInput htmlInput = m_htmlInputList.get(i);
			htmlInput.print(p_out);
		}
	}
	
	/**
	 * ׂĂinput^ONG𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_charset GR[hۂ̕Zbgw肵܂B
	 * @see <a href=
	 * "http://sdc.sun.co.jp/java/docs/j2se/1.4/ja/docs/ja/guide/intl/encoding.doc.html">
	 * Zbg</a>
	 * @return NG
	 * @throws UnsupportedEncodingException NG̃GR[hɎsꍇ
	 */
	protected String createQueryString(String p_charset) throws UnsupportedEncodingException {
		String returnValue = "";
		for (int i=0; i<m_htmlInputList.size(); i++) {
			HtmlInput htmlInput = m_htmlInputList.get(i);
			String type = htmlInput.getType();
			if (htmlInput.getName().equals("")) continue;
			if (type.equals("submit") || type.equals("reset")) {
				// submitreset͉ĂȂƑMΏۊOɂȂ
				if (htmlInput.isSelected()) {
					returnValue += "&" + htmlInput.getName() + "=" + 
						URLEncoder.encode(htmlInput.getValue(), p_charset);
				}
			} else if (	type.equals("checkbox") || type.equals("radio")) {
				// radiocheckbox̓`FbNĂȂƑMΏۊOɂȂ
				// ܂`FbNĂvalueȂꍇon
				if (htmlInput.isSelected()) {
					if (htmlInput.getValue().equals("")) {
						returnValue += "&" + htmlInput.getName() + "=on";
					} else {
						returnValue += "&" + htmlInput.getName() + "=" + 
							URLEncoder.encode(htmlInput.getValue(), p_charset);
					}
				}
			} else {
				returnValue += "&" + htmlInput.getName() + "=" + 
					URLEncoder.encode(htmlInput.getValue(), p_charset);
			}
		}
		return returnValue;
	}

	/**
	 * w肳ꂽinput^OXgƌ`mF܂B
	 * 
	 * @since 1.00
	 * @param p_other input^OXg
	 * @return w肳ꂽinput^OXgƌ`ꍇtrueԂ܂B
	 */
	public boolean equalsFormat(HtmlInputList p_other) {
		if (m_htmlInputList.size()!=p_other.m_htmlInputList.size()) 
			return false; 
		for (int i=0;i<m_htmlInputList.size();i++) {
			HtmlInput me = m_htmlInputList.get(i);
			HtmlInput other = p_other.m_htmlInputList.get(i);
			if (!me.equalsFormat(other)) return false;
		}
		return true;	
	}
	
	/**
	 * input^OXg폜܂B
	 * 
	 * @since 1.20
	 * @param p_htmlInput 폜input^O
	 */
	public void remove(HtmlInput p_htmlInput) {
		m_htmlInputList.remove(p_htmlInput);
	}
	
}
