/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.net;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

/**
 * httpʐMŎ擾CookieێNX
 * 
 * @since 1.10
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class CookieList {

	/**
	 * CookiẽXg
	 * 
	 * @since 1.10
	 */
	private ArrayList<Cookie> m_cookieList;
	
	/**
	 * CookieList𐶐܂B
	 * 
	 * @since 1.10
	 */
	public CookieList() {
		m_cookieList = new ArrayList<Cookie>();
	}
	
	/**
	 * œnꂽURL瑗MׂCookie𐶐ĕԂ܂B
	 * 
	 * @since 1.12
	 * @param p_url MURL
	 * @param p_charset GR[hۂ̕Zbgw肵܂B
	 * @see <a href=
	 * "http://sdc.sun.co.jp/java/docs/j2se/1.4/ja/docs/ja/guide/intl/encoding.doc.html">
	 * Zbg</a>
	 * @return Cookiei[httpwb_[
	 * @throws CookieException Cookie͂Ɏsꍇ
	 */
	protected final HttpHeader createRequestCookie(String p_url, String p_charset) throws CookieException {
		String cookies = "";
		for (Cookie cookie: m_cookieList) {
			if (cookie.isSecure()) {
				if (!p_url.substring(0,8).equals("https://")) continue;
			}
			if (!cookie.getDomain().equals("")) {
				if (p_url.indexOf(cookie.getDomain())==-1) continue;
			}
			if (!cookie.getPath().equals("")) {
				if (p_url.indexOf(cookie.getPath())==-1) continue;
			}
			try {
				if (cookies.equals(""))
					cookies += cookie.getName() + "=" + cookie.getEncodeValue(p_charset);
				else
					cookies += ";" + cookie.getName() + "=" + cookie.getEncodeValue(p_charset);
			} catch (UnsupportedEncodingException e) {
				throw new CookieException("createRequestCookie Encode Error URL="+p_url+" charset="+p_charset+
						" value="+cookie.getValue()+": "+e.getMessage());
			}
		}
		if (cookies.equals("")) return null;
		return new HttpHeader("Cookie",cookies);
	}
	
	/**
	 * Set-Cookiewb_[荞݂܂B
	 * 
	 * @since 1.12
	 * @param p_originUrl CookiesURL
	 * @param p_setCookieHeader Set-Cookiewb_[̓e
	 * @throws CookieException CookiesURLsȏꍇ
	 */
	protected final void importResponseCookie(String p_originUrl, String p_setCookieHeader) 
		throws CookieException {
		try {
			Cookie cookie = parseCookie(p_originUrl, p_setCookieHeader);
			// hC̃ftHgCookiesTCg
			URL url = new URL(cookie.getOriginUrl());
			if (cookie.getDomain().equals("")) {
				cookie.setDomain(url.getHost());
			}
			// ZLeB΍|T[o[CookienȂ
			if (p_originUrl.indexOf(cookie.getDomain())==-1) {
				cookie.setDomain(url.getHost());
			}
			// Xgɓo^
			if (!cookie.getName().equals("") && !cookie.getValue().equals("")) {
				int index = m_cookieList.indexOf(cookie);
				if (index==-1) {
					m_cookieList.add(cookie);
				} else {
					m_cookieList.remove(index);
					m_cookieList.add(cookie);
				}
			}
		} catch (MalformedURLException e) {
			throw new CookieException("importResponseCookie Error p_originUrl="+p_originUrl+
					" Set-Cookie="+p_setCookieHeader+" :"+e.getMessage());
		}
	}
	
	/**
	 * Set-Cookiewb_[͂CookieNX`ɂĕԂ܂B
	 * 
	 * @since 1.12
	 * @param p_originUrl CookiesURL
	 * @param p_setCookieHeader Set-Cookiewb_[̓e
	 * @return CookieIuWFNg
	 */
	private final Cookie parseCookie(String p_originUrl, String p_setCookieHeader) {
		Cookie returnValue = new Cookie();
		String[] items = p_setCookieHeader.split(";");
		if (items==null) return null;
		returnValue.setOriginUrl(p_originUrl);
		for (String item: items) {
			if (item==null) continue;
			if (item.indexOf("=")==-1) {
				if (item.trim().equalsIgnoreCase("Secure")) {
					returnValue.setSecure(true);
				}
			} else {
				String[] fields = item.split("=");
				if (fields.length<2) continue;
				if (fields[0]==null) continue;
				if (fields[1]==null) continue;
				String fieldName = fields[0].trim();
				String fieldValue = fields[1].trim();
				if (fieldName.equalsIgnoreCase("Expires")) {
					returnValue.setExpires(fieldValue);
				} else	if (fieldName.equalsIgnoreCase("Domain")) {
					returnValue.setDomain(fieldValue);
				} else 	if (fieldName.equalsIgnoreCase("Path")) {
					returnValue.setPath(fieldValue);
				} else {
					if (!fieldName.equals("") && !fieldValue.equals("")) {
						returnValue.setName(fieldName);
						returnValue.setValue(fieldValue);
					}
				}
			}
		}
		return returnValue;
	}
	
}
