/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import java.util.Iterator;

/**
 * XgLXeBNX̃Xg
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class StochasticsList extends IndexObjectList<Stochastics> {

	/**
	 * VAo[WID
	 *  
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * l߂鎞̃[\N
	 * 
	 * @since 1.00
	 */
	private final int m_ccountRange;

	/**
	 * %DSlow%D߂鎞̏Wv
	 * 
	 * @since 1.00
	 */
	private final int m_pcountD;
	
	/**
	 * StochasticsList𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_ccountRange lZo邽߂Ɏg[\N
	 * @param p_pcountD %DSlow%DZo邽߂Ɏg|Cg
	 */
	public StochasticsList(int p_ccountRange, int p_pcountD) {
		m_ccountRange = p_ccountRange;
		m_pcountD = p_pcountD;
	}
	
	/**
	 * \[X[\NXgXgLXeBNXZoăXgɒǉ܂B
	 * 
	 * @since 1.00
	 * @param p_src \[X[\NXg
	 */
	public void addObject(CandleStickList p_src) {
		// TCY`FbN
		if (p_src==null) return;
		if (p_src.size()<m_ccountRange) {
			return;
		}
		// XgLXvZ郍[\Ni荞
		CandleStickList tail = new CandleStickList(p_src.getTailList(m_ccountRange));
		if (tail.getLast()==null) return;
		// %K̎Zo
		CandleStick c = p_src.getLast();
		Stochastics stochastics = new Stochastics(c.getTag());
		stochastics.setCurrentRange(getCurrentRange(tail));
		stochastics.setMaxRange(getMaxRange(tail));
		stochastics.setK(100*stochastics.getCurrentRange()/stochastics.getMaxRange());
		add(stochastics);
		// %D̎Zo
		if (size()>=m_pcountD) { 
			double sumCurrentRange = 0;
			double sumMaxRange = 0;
			IndexObjectList<Stochastics> ds = getTailList(m_pcountD);
			for (Iterator<Stochastics> i=ds.getObjectList().iterator();i.hasNext();) {
				Stochastics p = i.next();
				sumCurrentRange += p.getCurrentRange();
				sumMaxRange += p.getMaxRange();
			}
			stochastics.setD(100*sumCurrentRange/sumMaxRange);
		} else {
			stochastics.setD(0);
		}
		// rc̎Zo
		if (size()>=m_pcountD) {
			double sumD = 0;
			IndexObjectList<Stochastics> ds = getTailList(m_pcountD);
			for (Iterator<Stochastics> i=ds.getObjectList().iterator();i.hasNext();) {
				Stochastics p = i.next();
				sumD += p.getD();
			}
			stochastics.setSlowD(sumD / m_pcountD);
		} else {
			stochastics.setSlowD(0);
		}
	}
	
	/**
	 * ňl猻ݒl̒lԂ܂B
	 * 
	 * @since 1.00
	 * @param p_src \[X[\NXg
	 * @return ňl猻ݒl̒l
	 */
	private double getCurrentRange(CandleStickList p_src) {
		CandleStick c = p_src.getLast();
		return c.getClose() - p_src.getMin();
	}
	
	/**
	 * ňlōl̒lԂ܂B
	 * 
	 * @since 1.00
	 * @param src \[X[\NXg
	 * @return ňlōl̒l
	 */
	private double getMaxRange(CandleStickList src) {
		return src.getMax() - src.getMin();
	}

}
