/**
 * Copyright (C) 2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import jp.robotbrain.signal.IndexLine;

/**
 * ㏸VOi<br>
 * O|Cg|Cg̒l傫Ύw肵VOio͂܂B
 * O|Cgƍ|Cgꍇ͑ÕVOip܂B
 * 
 * @since 2.20
 * @author Copyright (C) 2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@TypeSignalStream
@EnabledOutputSignal
@InputComponentList(values={"@IndexLine"})
public class RiseSignal extends SignalStream {

	/**
	 * RiseSignal𐶐܂B
	 * 
	 * @since 2.20
	 * @param p_label x
	 * @param p_priority Dx
	 * @param p_outputSignal ɏo͂VOi
	 */
	public RiseSignal(String p_label, int p_priority, NmSignal p_outputSignal) {
		super(p_label, p_priority, p_outputSignal);
		getPortList().add("@IndexLine",2);
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.Signal#getJudgmentResultSub()
	 */
	@Override
	protected JudgmentResult getJudgmentResultSub() throws IndexStreamException {
		IndexStreamPort p = getPortList().get("@IndexLine");
		// portnull`FbN
		if (p==null)
			throw new IndexStreamException("Port Null Error");
		// Cnull`FbN
		if (p.getObjectList()==null) return new JudgmentResult(null,NmSignal.NOSIGNAL);
		// CX^X`FbN
		if (!(p.getObjectList() instanceof IndexLine))
			throw new IndexStreamException("Instance Error");
		// TCY`FbN
		IndexLine line = (IndexLine)p.getObjectList();
		if (line.size()<2) {
			return new JudgmentResult(null,NmSignal.NOSIGNAL);
		}
		// VOi
		NmSignal returnValue = NmSignal.NOSIGNAL;
		if (line.getLast().getValue() > line.getPrev(1).getValue()) {
			returnValue = getOutputSignal();
		} else if (line.getLast().getValue() == line.getPrev(1).getValue()) {
			// Ȃꍇ͑OƓ
			if (getLastJudgmentResult()!=null) {
				returnValue = getLastJudgmentResult().getSignal();
			}
		}
		return new JudgmentResult(line.getLast().getTag(),returnValue);
	}
	
}
