/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import jp.robotbrain.signal.SimpleLine;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.IndexPoint;

/**
 * VvCXg[
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2010 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@EntryPoint
@FrameworkParameter
@TypeIndexStream("SimpleLine")
@InputComponentList(values={"@IndexLine"})
public class SimpleLineStream extends IndexLineStream {

	/**
	 * VAo[WID
	 *  
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * VvC
	 * 
	 * @since 1.00
	 */
	private final SimpleLine m_simpleLine;
	
	/**
	 * SimpleLineStream𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_label x
	 */
	public SimpleLineStream(String p_label) {
		super(p_label);
		m_simpleLine = new SimpleLine();
	}

	/**
	 * Xg[̓
	 * 
	 * @since 1.00
	 * @param p_src \[X|Cg
	 * @throws IndexStreamException eNjJwWZoʒmɈُ킪ꍇ
	 */
	public void enter(IndexPoint p_src) throws IndexStreamException {
		// null`FbN
		if (p_src==null) {
			throw new IndexStreamException("Null Error");
		}
		// |Cgǉ
		m_simpleLine.addPoint(p_src);
		// ̃eNjJwWɒʒm
		notifyIndexNext(m_simpleLine);
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexStream#notifyIndexSub(jp.robotbrain.signal.IndexObjectList)
	 */
	@Override
	public void notifyIndexSub(IndexObjectList<?> p_indexObjectList)
		throws IndexStreamException {
		// CX^X`FbN
		if (!(p_indexObjectList instanceof IndexLine)) {
			throw new IndexStreamException("Instance Error");
		}
		// |Cgǉ
		if (p_indexObjectList.size()>0) {
			IndexLine il = (IndexLine)p_indexObjectList;
			m_simpleLine.addPoint(il.getLast());
		}
		// ̃eNjJwWɒʒm
		notifyIndexNext(m_simpleLine);
	}

	/**
	 * VvCԂ܂B
	 * 
	 * @since 1.00
	 * @return VvC
	 */
	@Override
	public SimpleLine getValues() {
		return m_simpleLine;
	}	
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexStreamDestination#getCost()
	 */
	@Override
	public int getCost() {
		return 1;
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexStream#economizeCapacity()
	 */
	@Override
	public void economizeCapacity() {
		m_simpleLine.setCapacity(getDestinationMaxCost());
	}
	
}
