/**
 * Copyright (C) 2008-2012 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import java.util.ArrayList;
import java.util.Collections;

/**
 * VOĩubN<br>
 * ̎VOiP̎VOi𓱂o܂B
 * SignalBlock͂܂̓VOiVOi̎ށi""A""
 * A"ޏo"jPriorityZPriorityő̃VOiT
 * ܂BĂ̍ő̃VOi""VOiPriorityZ
 * l100ɒBĂ΂̃VOiAEgvbg̃VOi
 * ɂ܂B
 * ǂ̃VOiɂłȂꍇi=50,=50̂悤ɃVO
 * iPriorityŊꂽꍇƁAőVOi""VOi
 * PriorityZĂ100ɒBȂꍇjADefaultSignalAE
 * gvbg̃VOiƂ܂B
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@TypeSignalBlock
@EnabledDefaultSignal
// uany@v͂łڑ\ȂƂӖ
@InputComponentList(values={"any@Signal"})
public class SignalBlock extends Signal {

	/**
	 * VAo[WID
	 *  
	 * @since 2.60
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * ̓VOi
	 * 
	 * @since 1.00
	 */
	private final ArrayList<Signal> m_inputSignalList;
	
	/**
	 * SignalBlock𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_label x
	 * @param p_priority Dx
	 */
	public SignalBlock(String p_label, int p_priority) {
		super(p_label, p_priority);
		m_inputSignalList = new ArrayList<Signal>();
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.Signal#getJudgmentResultSub()
	 */
	@Override
	protected JudgmentResult getJudgmentResultSub() throws IndexStreamException {
		// Wv
		SummaryPriority sumPriority = getSummaryPriority();
		// ŐV^O̎擾
		Tag inputTag = getInputTag();
		if (inputTag==null) return new JudgmentResult(null,NmSignal.NOSIGNAL);
		// őVOi̎擾
		SimpleSignal max = sumPriority.getMaxSignal(inputTag);
		// VOi
		NmSignal returnValue = getDefaultSignal();
		if (max!=null) {
			if (max.getPriority()+sumPriority.getNeutral()>=100) {
				returnValue = max.getLastJudgmentResult().getSignal();
			}
		}
		return new JudgmentResult(inputTag,returnValue);
	}
	
	/**
	 * ߂̓̓VOĩ^OԂ܂B
	 * 
	 * @since 1.20
	 * @return ^O
	 * @throws IndexStreamException eNjJwW̓ǂݍ݂ňُ킪ꍇ
	 */
	protected Tag getInputTag() throws IndexStreamException {
		if (m_inputSignalList.size()<=0) return null;
		Signal max = null;
		try {
			max = Collections.max(m_inputSignalList, new SignalTagComparator());
		} catch (ClassCastException e) {
			return null;
		}
		return max.getLastJudgmentResult().getTag();
	}
	
	/**
	 * ̓VOiǉ܂B
	 * 
	 * @since 1.00
	 * @param p_tradeSignal VOi
	 */
	public void addInputSignal(Signal p_tradeSignal) {
		m_inputSignalList.add(p_tradeSignal);
	}
	
	/**
	 * w̎VOi̗Dx̍ZԂ܂B
	 * 
	 * @since 1.21
	 * @param p_tradeSignal VOi
	 * @return Dx̍Zl
	 */
	private SummaryPriority getSummaryPriority() throws IndexStreamException {
		SummaryPriority returnValue = new SummaryPriority();
		for (Signal inputSignal : m_inputSignalList) {
			switch (inputSignal.getJudgmentResult().getSignal()) {
			case LONG:
				returnValue.addLong(inputSignal.getPriority());
				break;
			case SHORT:
				returnValue.addShort(inputSignal.getPriority());
				break;
			case ESCAPE:
				returnValue.addEscape(inputSignal.getPriority());
				break;
			case NEUTRAL:
				returnValue.addNeutral(inputSignal.getPriority());
				break;
			case ADD:
				returnValue.addAdd(inputSignal.getPriority());
				break;
			case SUB:
				returnValue.addSub(inputSignal.getPriority());
				break;
			}
		}
		return returnValue;
	}

	/**
	 * ̓VOĩXgԂ܂B
	 * 
	 * @since 2.33
	 * @return ̓VOĩXg
	 */
	protected ArrayList<Signal> getInputSignalList() {
		return m_inputSignalList;
	}
	
}
