/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.net;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

/**
 * httpʐMŎgCookiȅ
 * 
 * @since 1.10
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class Cookie {

	/**
	 * O
	 * 
	 * @since 1.10
	 */
	private String m_name;

	/**
	 * l
	 * 
	 * @since 1.10
	 */
	private String m_value;

	/**
	 * L
	 * 
	 * @since 1.10
	 */
	private String m_expires;

	/**
	 * MΏۃhC
	 * 
	 * @since 1.10
	 */
	private String m_domain;

	/**
	 * MΏۃpX
	 * 
	 * @since 1.10
	 */
	private String m_path;
	
	/**
	 * ZLAʐMtO
	 * 
	 * @since 1.10
	 */
	private boolean m_secure;
	
	/**
	 * CookiesURL
	 * 
	 * @since 1.12
	 */
	private String m_originUrl;

	/**
	 * Cookie𐶐܂B
	 */
	public Cookie() {
		m_name = "";
		m_value = "";
		m_expires = "";
		m_domain = "";
		m_path = "";
		m_originUrl = "";
		m_secure = false;
	}
	
	/**
	 * Oݒ肵܂B
	 * 
	 * @since 1.10
	 * @param p_name O
	 */
	public final void setName(String p_name) {
		m_name = p_name;
	}

	/**
	 * OԂ܂B
	 * 
	 * @since 1.10
	 * @return O
	 */
	public final String getName() {
		return m_name;
	}

	/**
	 * lݒ肵܂B
	 * 
	 * @since 1.10
	 * @param p_value l
	 */
	public final void setValue(String p_value) {
		m_value = p_value;
	}

	/**
	 * lԂ܂B
	 * 
	 * @since 1.10
	 * @return l
	 */
	public final String getValue() {
		return m_value;
	}

	/**
	 * GR[hlԂ܂B
	 * 
	 * @since 1.12
	 * @param p_charset GR[hۂ̕Zbgw肵܂B
	 * @see <a href=
	 * "http://docs.oracle.com/javase/7/docs/technotes/guides/intl/encoding.doc.html">
	 * Zbg</a>
	 * @return GR[hl
	 * @throws UnsupportedEncodingException GR[hɎsꍇ
	 */
	public final String getEncodeValue(String p_charset) throws UnsupportedEncodingException {
		return URLEncoder.encode(m_value, p_charset);
	}
	
	/**
	 * Lݒ肵܂B
	 * 
	 * @since 1.10
	 * @param p_expires L
	 */
	public final void setExpires(String p_expires) {
		m_expires = p_expires;
	}

	/**
	 * LԂ܂B
	 * 
	 * @since 1.10
	 * @return L
	 */
	public final String getExpires() {
		return m_expires;
	}

	/**
	 * MΏۃhCݒ肵܂B
	 * 
	 * @since 1.10
	 * @param p_domain MΏۃhC
	 */
	public final void setDomain(String p_domain) {
		m_domain = p_domain;
	}

	/**
	 * MΏۃhCԂ܂B
	 * 
	 * @since 1.10
	 * @return MΏۃhC
	 */
	public final String getDomain() {
		return m_domain;
	}

	/**
	 * MΏۃpXݒ肵܂B
	 * 
	 * @since 1.10
	 * @param p_path MΏۃpX
	 */
	public final void setPath(String p_path) {
		m_path = p_path;
	}

	/**
	 * MΏۃpXԂ܂B
	 * 
	 * @since 1.10
	 * @return MΏۃpX
	 */
	public final String getPath() {
		return m_path;
	}

	/**
	 * ZLAʐMtOݒ肵܂B
	 * 
	 * @since 1.10
	 * @param p_secure ZLAʐMtO
	 */
	public final void setSecure(boolean p_secure) {
		m_secure = p_secure;
	}

	/**
	 * ZLAʐMtOԂ܂B
	 * 
	 * @since 1.10
	 * @return ZLAʐMtO
	 */
	public final boolean isSecure() {
		return m_secure;
	}
	
	/**
	 * ̃CX^XƓr܂B
	 * 
	 * @since 1.10
	 * @param p_other ̃CX^X
	 * @return ̃CX^XƓꍇtrue
	 */
	@Override
	public final boolean equals(Object p_other) {
		if (p_other instanceof Cookie) {
			Cookie other = (Cookie)p_other;
			return other.getName().equals(m_name);
		}
		return false;
	}
	
	/**
	 * nbVR[hԂ܂B
	 * 
	 * @since 1.10
	 * @return nbVR[h
	 */
	@Override
	public final int hashCode() {
		return m_name.hashCode();
	}

	/**
	 * CookiesURLݒ肵܂B
	 * 
	 * @since 1.12
	 * @param p_originUrl CookiesURL
	 */
	public void setOriginUrl(String p_originUrl) {
		m_originUrl = p_originUrl;
	}

	/**
	 * CookiesURLԂ܂B
	 * 
	 * @since 1.12
	 * @return CookiesURL
	 */
	public String getOriginUrl() {
		return m_originUrl;
	}
	
}
