/**
 * Copyright (C) 2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.common;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

/**
 * VACYt@CǂݏNX
 * 
 * @since 2.05
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class ObjectFile {

	/**
	 * t@C̃pX
	 * 
	 * @since 2.05
	 */
	private String m_filePath;

	/**
	 * ObjectFile𐶐܂
	 * 
	 * @since 2.05
	 * @param p_filePath t@C̃pX
	 */
	public ObjectFile(String p_filePath) {
		m_filePath = p_filePath;
	}
	
	/**
	 * VACYt@CioCit@Cj݂܂
	 * 
	 * @since 2.33
	 * @param p_src t@Cɏo͂IuWFNg
	 * @throws IOException t@C݂̏Ɏsꍇ
	 */
	public void writeBinary(Object p_src) throws IOException {
		FileOutputStream outFile = new FileOutputStream(m_filePath);
		ObjectOutputStream outObject = new ObjectOutputStream(outFile);
		outObject.writeObject(p_src);
		outObject.close();
		outFile.close();
	}

	/**
	 * VACYt@CioCit@Cjǂݍ݂܂
	 * 
	 * @since 2.33
	 * @return t@Cǂݍ񂾃IuWFNg
	 * @throws IOException t@C̓ǂݍ݂Ɏsꍇ
	 * @throws ClassNotFoundException 񉻂ꂽIuWFNg̃NXȂꍇ
	 */
	public Object readBinary() throws IOException, ClassNotFoundException {
		FileInputStream inFile = new FileInputStream(m_filePath);
		ObjectInputStream inObject = new ObjectInputStream(inFile);
		Object returnValue = inObject.readObject();
		inObject.close();
		inFile.close();
		return returnValue;
	}

	/**
	 * VACYt@Ciwlkt@Cj݂܂
	 * 
	 * @since 2.33
	 * @param p_src t@Cɏo͂IuWFNg
	 * @throws IOException t@C݂̏Ɏsꍇ
	 */
	public void writeXML(Object p_src) throws IOException {
		FileOutputStream outFile = new FileOutputStream(m_filePath);
		BufferedOutputStream outBuf = new BufferedOutputStream(outFile);
		XMLEncoder outXml = new XMLEncoder(outBuf); 
		outXml.writeObject(p_src); 
		outXml.close(); 
		outBuf.close(); 
		outFile.close(); 
	}

	/**
	 * VACYt@Ciwlkt@Cjǂݍ݂܂
	 * 
	 * @since 2.33
	 * @return t@Cǂݍ񂾃IuWFNg
	 * @throws IOException t@C̓ǂݍ݂Ɏsꍇ
	 */
	public Object readXML() throws IOException {
		FileInputStream inFile = new FileInputStream(m_filePath);
		BufferedInputStream inBuf = new BufferedInputStream(inFile);
		XMLDecoder inXml = new XMLDecoder(inBuf);
		Object returnValue = inXml.readObject(); 
		inXml.close();
		inBuf.close();
		inFile.close();
		return returnValue;
	}
	
}
