/**
 * Copyright (C) 2008-2011 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;


/**
 * ZCiCvbglw肵{Ŋ|lێ郉CjXg[
 * 
 * @since 1.02
 * @author Copyright (C) 2008-2011 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@TypeIndexStream("MultiplicationLine")
@InputComponentList(values={"A@IndexLine","B@IndexLine"})
public class MultiplicationLineStream extends IndexLineStream {

	/**
	 * VAo[WID
	 *  
	 * @since 1.02
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * ZC
	 * 
	 * @since 1.02
	 */
	private final MultiplicationLine m_multiplicationLine;
	
	/**
	 * MultiplicationLineStream𐶐܂B
	 * 
	 * @since 2.60
	 * @param p_label x
	 */
	public MultiplicationLineStream(String p_label) {
		super(p_label);
		// ZC̐
		m_multiplicationLine = new MultiplicationLine();
		// eNjJwW̓|[gݒ
		getPortList().add("A@IndexLine",1);
		getPortList().add("B@IndexLine",1);
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexStream#notifyIndexSub()
	 */
	@Override
	public void notifyIndexSub() throws IndexStreamException {
		// eNjJwW̓|[g擾
		IndexStreamPort portA = getPortList().get("A@IndexLine");
		IndexStreamPort portB = getPortList().get("B@IndexLine");
		// CX^X`FbN
		if (!(portA.getIndexStream().getValues() instanceof IndexLine)) {
			throw new IndexStreamException("A Instance Error");
		}
		if (!(portB.getIndexStream().getValues() instanceof IndexLine)) {
			throw new IndexStreamException("B Instance Error");
		}
		// ^O`FbN
		if (!portA.getIndexStream().getValues().getLast().getTag().equals(
				portB.getIndexStream().getValues().getLast().getTag())) return;
		// |Cgǉ
		m_multiplicationLine.addPoint((IndexLine)portA.getIndexStream().getValues(), 
				(IndexLine)portB.getIndexStream().getValues());
		// ̃eNjJwWɒʒm
		notifyIndexNext();
	}

	/**
	 * ZCԂ܂B
	 * 
	 * @since 1.02
	 * @return ZC
	 */
	@Override
	public MultiplicationLine getValues() {
		return m_multiplicationLine;
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexStream#economizeCapacity()
	 */
	@Override
	public void economizeCapacity() {
		m_multiplicationLine.setCapacity(getDestinationMaxCost());
	}
	
}
